/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.map.executor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.map.MapperFactory;
import net.binis.codegen.map.Mapping;
import net.binis.codegen.map.executor.MapperExecutor;

public class DefaultMapperExecutor
implements MapperFactory {
    protected final Map<String, Mapping> mappers = new ConcurrentHashMap<String, Mapping>();

    @Override
    public <T> T map(Object source, Class<T> destination) {
        return this.map(source, CodeFactory.create(destination, new Object[0]), destination);
    }

    @Override
    public <T> T map(Object source, T destination) {
        Mapping mapper = this.mappers.get(this.calcMapperName(source.getClass(), destination.getClass()));
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapper(source, destination, false);
        }
        return mapper.map(source, destination);
    }

    protected <T> T map(Object source, T destination, Class<T> cls) {
        Mapping mapper = this.mappers.get(this.calcMapperName(source.getClass(), cls));
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapper(source, destination, false);
        }
        return mapper.map(source, destination);
    }

    @Override
    public Mapping mapping(Class source, Class destination) {
        return this.buildMapperClass(source, destination, false, false);
    }

    @Override
    public <T> T convert(Object source, Class<T> destination) {
        return this.convert(source, CodeFactory.create(destination, new Object[0]), destination);
    }

    @Override
    public <T> T convert(Object source, Class<T> destination, Object ... params) {
        return this.convert(source, CodeFactory.create(destination, params), destination);
    }

    @Override
    public <T> T convert(Object source, T destination) {
        Mapping mapper = this.mappers.get(this.calcMapperName(source.getClass(), destination.getClass()));
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapper(source, destination, true);
        }
        return mapper.map(source, destination);
    }

    protected <T> T convert(Object source, T destination, Class<T> cls) {
        Mapping mapper = this.mappers.get(this.calcMapperName(source.getClass(), cls));
        if (Objects.isNull(mapper)) {
            mapper = this.buildMapperClass(source.getClass(), cls, true, true);
        }
        return mapper.map(source, destination);
    }

    @Override
    public boolean canMap(Class<?> source, Class<?> destination) {
        return Objects.nonNull(this.getMap(source, destination));
    }

    @Override
    public boolean canMapExactly(Class<?> source, Class<?> destination) {
        return Objects.nonNull(this.getExactMap(source, destination));
    }

    @Override
    public <S, D> Mapping<S, D> getMap(Class<S> source, Class<D> destination) {
        return this.findMapper(source, destination);
    }

    @Override
    public <S, D> Mapping<S, D> getExactMap(Class<S> source, Class<D> destination) {
        return this.mappers.get(this.calcMapperName(source, destination));
    }

    @Override
    public void registerMapper(Mapping<?, ?> mapping) {
        this.mappers.put(this.calcMapperName(mapping.getSource(), mapping.getDestination()), mapping);
    }

    @Override
    public <S, D> List<Mapping<S, D>> findMappings(Class<S> source, Class<D> destination) {
        LinkedHashMap<Class, Mapping> result = new LinkedHashMap<Class, Mapping>();
        this.findMappings(result, source, destination);
        if (result.isEmpty()) {
            this.findReverseMappings(result, source, destination);
        }
        if (result.isEmpty()) {
            this.findJoinMappings(result, source, destination);
        }
        return result.values().stream().toList();
    }

    @Override
    public <S, D> Mapping<S, D> clearMapping(Class<S> source, Class<D> destination) {
        return this.mappers.remove(this.calcMapperName(source, destination));
    }

    @Override
    public void clearAllMappings() {
        this.mappers.clear();
    }

    protected void findMappings(Map<Class, Mapping> map, Class source, Class destination) {
        Mapping mapping = this.mappers.get(this.calcMapperName(source, destination));
        if (Objects.nonNull(mapping)) {
            map.putIfAbsent(source, mapping);
        } else {
            for (Class<?> intf : source.getInterfaces()) {
                this.findMappings(map, intf, destination);
            }
            Class superClass = this.getSuperClass(source);
            if (Objects.nonNull(superClass)) {
                this.findMappings(map, superClass, destination);
            }
        }
    }

    protected <S> void findReverseMappings(Map<Class<S>, Mapping<S, ?>> map, Class<S> source, Class<?> destination) {
        Mapping mapping = this.mappers.get(this.calcMapperName(source, destination));
        if (Objects.nonNull(mapping)) {
            map.putIfAbsent(source, mapping);
        } else {
            for (Class<?> intf : destination.getInterfaces()) {
                this.findReverseMappings(map, source, intf);
            }
            Class superClass = this.getSuperClass(destination);
            if (Objects.nonNull(superClass)) {
                this.findReverseMappings(map, source, superClass);
            }
        }
    }

    protected <S> void findJoinMappings(Map<Class, Mapping> map, Class<S> source, Class<?> destination) {
        Mapping mapping = this.mappers.get(this.calcMapperName(source, destination));
        if (Objects.nonNull(mapping)) {
            map.putIfAbsent(source, mapping);
        } else {
            for (Class<?> intf : destination.getInterfaces()) {
                for (Class<?> dIntf : destination.getInterfaces()) {
                    this.findMappings(map, intf, dIntf);
                    this.findReverseMappings(map, intf, dIntf);
                }
            }
            Class superClass = this.getSuperClass(source);
            while (Objects.nonNull(superClass)) {
                Class dSuperClass = this.getSuperClass(destination);
                while (Objects.nonNull(dSuperClass)) {
                    this.findJoinMappings(map, superClass, dSuperClass);
                    dSuperClass = this.getSuperClass(dSuperClass);
                }
                superClass = this.getSuperClass(superClass);
            }
        }
    }

    protected <T> MapperExecutor buildMapper(Object source, T destination, boolean convert) {
        return this.buildMapperClass(source.getClass(), destination.getClass(), convert, true);
    }

    protected <T> MapperExecutor buildMapperClass(Class source, Class destination, boolean convert, boolean register) {
        MapperExecutor result = new MapperExecutor(source, destination, convert);
        if (register) {
            this.mappers.put(this.calcMapperName(source, destination), result);
        }
        return result;
    }

    protected String calcMapperName(Class source, Class destination) {
        return source.getCanonicalName() + "->" + destination.getCanonicalName();
    }

    protected <S, D> Mapping<S, D> findMapper(Class<S> source, Class<D> destination) {
        return this.mappers.get(this.calcMapperName(source, destination));
    }

    protected Class getSuperClass(Class<?> cls) {
        Class<Object> result = cls.getSuperclass();
        if (Objects.isNull(result) && cls.isInterface()) {
            result = Object.class;
        }
        return result;
    }
}

