/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.binis.codegen.annotation.CodeConfiguration;
import net.binis.codegen.exception.MapperException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.map.Mapper;
import net.binis.codegen.objects.base.enumeration.CodeEnum;

@CodeConfiguration
public abstract class DefaultMappings {
    public static void initialize() {
        CodeFactory.registerType(Integer.TYPE, () -> 0);
        CodeFactory.registerType(Long.TYPE, () -> 0L);
        CodeFactory.registerType(Byte.TYPE, () -> (byte)0);
        CodeFactory.registerType(Short.TYPE, () -> (short)0);
        CodeFactory.registerType(Boolean.TYPE, () -> false);
        CodeFactory.registerType(Character.TYPE, () -> Character.valueOf('\u0000'));
        CodeFactory.registerType(Float.TYPE, () -> Float.valueOf(0.0f));
        CodeFactory.registerType(Double.TYPE, () -> 0.0);
        CodeFactory.registerType(Integer.class, () -> 0);
        CodeFactory.registerType(Long.class, () -> 0L);
        CodeFactory.registerType(Byte.class, () -> (byte)0);
        CodeFactory.registerType(Short.class, () -> (short)0);
        CodeFactory.registerType(Boolean.class, () -> false);
        CodeFactory.registerType(Character.class, () -> Character.valueOf('\u0000'));
        CodeFactory.registerType(Float.class, () -> Float.valueOf(0.0f));
        CodeFactory.registerType(Double.class, () -> 0.0);
        CodeFactory.registerType(String.class, () -> "");
        Mapper.registerMapper(Number.class, Integer.TYPE, (s, d) -> s.intValue());
        Mapper.registerMapper(Number.class, Integer.class, (s, d) -> s.intValue());
        Mapper.registerMapper(Number.class, Long.TYPE, (s, d) -> s.longValue());
        Mapper.registerMapper(Number.class, Long.class, (s, d) -> s.longValue());
        Mapper.registerMapper(Number.class, Byte.TYPE, (s, d) -> s.byteValue());
        Mapper.registerMapper(Number.class, Byte.class, (s, d) -> s.byteValue());
        Mapper.registerMapper(Number.class, Short.TYPE, (s, d) -> s.shortValue());
        Mapper.registerMapper(Number.class, Short.class, (s, d) -> s.shortValue());
        Mapper.registerMapper(Number.class, Boolean.TYPE, (s, d) -> s.intValue() != 0);
        Mapper.registerMapper(Number.class, Boolean.class, (s, d) -> s.intValue() != 0);
        Mapper.registerMapper(Number.class, Character.TYPE, (s, d) -> Character.valueOf((char)s.intValue()));
        Mapper.registerMapper(Number.class, Character.class, (s, d) -> Character.valueOf((char)s.intValue()));
        Mapper.registerMapper(Number.class, Float.TYPE, (s, d) -> Float.valueOf(s.floatValue()));
        Mapper.registerMapper(Number.class, Float.class, (s, d) -> Float.valueOf(s.floatValue()));
        Mapper.registerMapper(Number.class, Double.TYPE, (s, d) -> s.doubleValue());
        Mapper.registerMapper(Number.class, Double.class, (s, d) -> s.doubleValue());
        Mapper.registerMapper(Object.class, String.class, (s, d) -> s.toString());
        Mapper.registerMapperClass(String.class, Enum.class, (s, d) -> Enum.valueOf(d, s));
        Mapper.registerMapperClass(String.class, CodeEnum.class, (s, d) -> CodeFactory.enumValueOf(d, s));
        Mapper.registerMapperClass(Number.class, CodeEnum.class, (s, d) -> CodeFactory.enumValueOf(d, s.intValue()));
        Mapper.registerMapperClass(byte[].class, Serializable.class, (s, d) -> {
            Serializable serializable;
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream((byte[])s));
            try {
                serializable = (Serializable)is.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MapperException(e);
                }
            }
            is.close();
            return serializable;
        });
        Mapper.registerMapperClass(Serializable.class, byte[].class, (s, d) -> {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream os = new ObjectOutputStream(bos);){
                    os.writeObject(s);
                    byArray = bos.toByteArray();
                }
                return byArray;
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        });
    }

    private DefaultMappings() {
    }
}

