/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.collection;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.binis.codegen.collection.CodeSet;

public class CodeSetImpl<T, R>
implements CodeSet<T, R> {
    private final R parent;
    private final Set<T> set;
    private final Consumer<T> validator;

    public CodeSetImpl(R parent, Set<T> set) {
        this.parent = parent;
        this.set = set;
        this.validator = null;
    }

    public CodeSetImpl(R parent, Set<T> set, Consumer<T> validator) {
        this.parent = parent;
        this.set = set;
        this.validator = validator;
    }

    @Override
    public CodeSet<T, R> add(T value) {
        this.validate(value);
        this.set.add(value);
        return this;
    }

    @Override
    public R and() {
        return this.parent;
    }

    protected void validate(T value) {
        if (Objects.nonNull(this.validator)) {
            this.validator.accept(value);
        }
    }
}

