/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public abstract class Reflection {
    private static final Logger log = LoggerFactory.getLogger(Reflection.class);
    private static ClassLoader loader;
    private static Unsafe unsafe;

    public static Class<?> loadClass(String className) {
        try {
            return Objects.nonNull(loader) ? loader.loadClass(className) : Class.forName(className);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T instantiate(Class<T> cls, Object ... params) {
        return Reflection.findConstructor(cls, params).newInstance(params);
    }

    public static Constructor findConstructor(Class<?> cls, Object ... params) {
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != params.length) continue;
            Class<?>[] types = constructor.getParameterTypes();
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if ((!Objects.isNull(params[i]) || !types[i].isPrimitive()) && types[i].isAssignableFrom(params[i].getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (!Modifier.isPublic(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        throw new UnsupportedOperationException("Unable to find proper constructor for class " + cls.getCanonicalName());
    }

    public static void initialize(String cls, Object ... params) {
        Reflection.instantiate(Reflection.loadClass(cls), params);
    }

    public static Field findField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static <T> T getFieldValueUnsafe(Object obj, String name) {
        try {
            if (Objects.isNull(unsafe)) {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                unsafe = (Unsafe)f.get(null);
            }
            Field field = Reflection.findField(obj.getClass(), name);
            return (T)unsafe.getObject(obj, unsafe.objectFieldOffset(field));
        }
        catch (Exception e) {
            log.error("Unable to get value for field {} of {}", new Object[]{name, obj.getClass().getName(), e});
            return null;
        }
    }

    public static <T> T getFieldValue(Object obj, String name) {
        try {
            Field field = Reflection.findField(obj.getClass(), name);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            log.error("Unable to get value for field {} of {}", new Object[]{name, obj.getClass().getName(), e});
            return null;
        }
    }

    public static void withLoader(ClassLoader loader, Runnable task) {
        try {
            Reflection.loader = loader;
            task.run();
        }
        finally {
            Reflection.loader = null;
        }
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        return !method.getReturnType().equals(Void.TYPE) && method.getParameterCount() == 0 && (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) || name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)));
    }

    public static boolean isSetter(Method method) {
        String name = method.getName();
        return method.getReturnType().equals(Void.TYPE) && method.getParameterCount() == 1 && name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3));
    }

    public static boolean isWrapperType(Class<?> type) {
        return type == Double.class || type == Float.class || type == Long.class || type == Integer.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class;
    }

    public static Method findMethod(String name, Class<?> cls, Class<?> ... params) {
        Method result = null;
        try {
            result = cls.getDeclaredMethod(name, params);
        }
        catch (Exception e) {
            try {
                result = cls.getMethod(name, params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Object invoke(Method m, Object instance, Object ... args) {
        try {
            return m.invoke(instance, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeStatic(Method m, Object ... args) {
        try {
            return m.invoke(null, args);
        }
        catch (Exception e) {
            return null;
        }
    }
}

