/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.map.executor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.binis.codegen.exception.MapperException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.map.MapperFactory;
import net.binis.codegen.map.Mapping;
import net.binis.codegen.modifier.Modifier;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperExecutor<T>
implements Mapping<Object, T> {
    private static final Logger log = LoggerFactory.getLogger(MapperExecutor.class);
    protected BiFunction<Object, T, T> mapper;
    protected final Class<?> source;
    protected final Class<T> destination;
    protected final boolean convert;

    public MapperExecutor(Object source, T destination, boolean convert) {
        this.source = source.getClass();
        this.destination = destination.getClass();
        this.convert = convert;
        this.build();
    }

    public MapperExecutor(Class<?> source, Class<T> destination, boolean convert) {
        this.source = source;
        this.destination = destination;
        this.convert = convert;
        this.build();
    }

    @Override
    public Class getSource() {
        return this.source;
    }

    @Override
    public Class getDestination() {
        return this.destination;
    }

    @Override
    public T map(Object source, T destination) {
        return this.mapper.apply(source, destination);
    }

    protected void build() {
        HashMap<String, TriFunction> accessors = new HashMap<String, TriFunction>();
        if (this.convert) {
            this.buildConverter(accessors);
            if (accessors.isEmpty()) {
                this.buildMatcher(accessors);
            }
        } else {
            this.buildMatcher(accessors);
            if (accessors.isEmpty()) {
                this.buildConverter(accessors);
            }
        }
        if (accessors.isEmpty()) {
            this.mapper = (s, d) -> d;
        } else {
            List<TriFunction> list = accessors.values().stream().toList();
            this.mapper = (s, d) -> {
                Object wither = null;
                Object result = d;
                for (TriFunction accessor : list) {
                    Object res = accessor.apply(s, result, wither);
                    if (res instanceof WitherHolder) {
                        WitherHolder holder = (WitherHolder)res;
                        wither = holder.get();
                        continue;
                    }
                    result = res;
                }
                return result;
            };
        }
    }

    private void buildMatcher(HashMap<String, TriFunction> accessors) {
        if (Modifier.class.isAssignableFrom(this.destination)) {
            this.matchGettersModifier(accessors, this.source, this.destination);
        } else {
            this.matchGettersWithers(accessors, this.source, this.destination);
            this.matchGettersSetters(accessors, this.source, this.destination);
        }
    }

    private void buildConverter(HashMap<String, TriFunction> accessors) {
        List<Mapping<?, T>> mappings = CodeFactory.create(MapperFactory.class, new Object[0]).findMappings(this.source, this.destination);
        if (!mappings.isEmpty()) {
            Mapping first = mappings.get(0);
            if (first.getSource().isInterface()) {
                ArrayList list = new ArrayList();
                for (Mapping<?, T> item : mappings) {
                    list.add(item);
                    if (item.getSource().isInterface()) continue;
                    break;
                }
                accessors.put(first.getSource().getCanonicalName(), (s, d, w) -> {
                    Object result = d;
                    for (Mapping m : list) {
                        result = m.map(s, result);
                    }
                    return result;
                });
            } else {
                accessors.put(first.getSource().getCanonicalName(), (s, d, w) -> first.map(s, d));
            }
        }
    }

    protected void matchGettersSetters(Map<String, TriFunction> accessors, Class<?> source, Class<?> destination) {
        Map<String, Method> getters = Arrays.stream(source.getMethods()).filter(Reflection::isGetter).filter(m -> java.lang.reflect.Modifier.isPublic(m.getModifiers())).collect(Collectors.toMap(k -> this.getFieldName(k.getName()), v -> v));
        Map<String, Method> setters = Arrays.stream(destination.getMethods()).filter(Reflection::isSetter).filter(m -> java.lang.reflect.Modifier.isPublic(m.getModifiers())).collect(Collectors.toMap(k -> this.getFieldName(k.getName()), v -> v));
        if (!setters.isEmpty()) {
            for (Map.Entry<String, Method> entry : getters.entrySet()) {
                if (accessors.containsKey(entry.getKey())) continue;
                Method setter = setters.get(entry.getKey());
                Method getter = entry.getValue();
                try {
                    getter.setAccessible(true);
                    if (!Objects.nonNull(setter)) continue;
                    String name = entry.getKey();
                    Class<?> srcType = getter.getReturnType();
                    Class<?> destType = setter.getParameterTypes()[0];
                    if (destType.isAssignableFrom(srcType) || this.isNonNullableToNullable(srcType, destType)) {
                        this.addPlainGetterSetterMapping(accessors, destination, getter, setter, name);
                        continue;
                    }
                    if (this.isNullableToNonNullable(srcType, destType)) {
                        this.addNullProtectedGetterSetterMapping(accessors, destination, getter, setter, name);
                        continue;
                    }
                    this.addConverter(accessors, source, destination, getter, setter, name);
                }
                catch (Exception e) {
                    log.info("Getter ({}) on {} is not accessible!", (Object)getter.getName(), (Object)source.getCanonicalName());
                }
            }
        }
    }

    protected void matchGettersWithers(Map<String, TriFunction> accessors, Class<?> source, Class<?> destination) {
        try {
            Method wither = destination.getDeclaredMethod("with", new Class[0]);
            wither.setAccessible(true);
            boolean witherAdded = false;
            Map<String, Method> getters = Arrays.stream(source.getMethods()).filter(Reflection::isGetter).filter(m -> java.lang.reflect.Modifier.isPublic(m.getModifiers())).collect(Collectors.toMap(k -> this.getFieldName(k.getName()), v -> v));
            Map<String, Method> withers = Arrays.stream(wither.getReturnType().getMethods()).filter(m -> java.lang.reflect.Modifier.isPublic(m.getModifiers())).filter(m -> m.getParameterCount() == 1).collect(Collectors.toMap(Method::getName, v -> v));
            if (!withers.isEmpty()) {
                for (Map.Entry<String, Method> entry : getters.entrySet()) {
                    if (accessors.containsKey(entry.getKey())) continue;
                    Method setter = withers.get(entry.getKey());
                    Method getter = entry.getValue();
                    try {
                        getter.setAccessible(true);
                        if (!Objects.nonNull(setter)) continue;
                        String name = entry.getKey();
                        Class<?> srcType = getter.getReturnType();
                        Class<?> destType = setter.getParameterTypes()[0];
                        if (!witherAdded) {
                            this.addWither(accessors, wither);
                            witherAdded = true;
                        }
                        if (destType.isAssignableFrom(srcType) || this.isNonNullableToNullable(srcType, destType)) {
                            this.addPlainGetterWitherMapping(accessors, destination, getter, setter, name);
                            continue;
                        }
                        if (this.isNullableToNonNullable(srcType, destType)) {
                            this.addNullProtectedGetterWitherMapping(accessors, destination, getter, setter, name);
                            continue;
                        }
                        this.addConverterWither(accessors, source, destination, getter, setter, name);
                    }
                    catch (Exception e) {
                        log.info("Getter ({}) on {} is not accessible!", (Object)getter.getName(), (Object)source.getCanonicalName());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void matchGettersModifier(Map<String, TriFunction> accessors, Class<?> source, Class<?> destination) {
        Map<String, Method> getters = Arrays.stream(source.getMethods()).filter(Reflection::isGetter).filter(m -> java.lang.reflect.Modifier.isPublic(m.getModifiers())).collect(Collectors.toMap(k -> this.getFieldName(k.getName()), v -> v));
        Map<String, Method> withers = Arrays.stream(destination.getMethods()).filter(m -> m.getParameterCount() == 1).filter(m -> m.getReturnType().isInterface()).filter(m -> m.getReturnType().isAssignableFrom(destination)).collect(Collectors.toMap(Method::getName, v -> v));
        if (!withers.isEmpty()) {
            for (Map.Entry<String, Method> entry : getters.entrySet()) {
                if (accessors.containsKey(entry.getKey())) continue;
                Method setter = withers.get(entry.getKey());
                Method getter = entry.getValue();
                try {
                    getter.setAccessible(true);
                    if (!Objects.nonNull(setter)) continue;
                    String name = entry.getKey();
                    Class<?> srcType = getter.getReturnType();
                    Class<?> destType = setter.getParameterTypes()[0];
                    if (destType.isAssignableFrom(srcType) || this.isNonNullableToNullable(srcType, destType)) {
                        this.addPlainGetterSetterMapping(accessors, destination, getter, setter, name);
                        continue;
                    }
                    if (this.isNullableToNonNullable(srcType, destType)) {
                        this.addNullProtectedGetterSetterMapping(accessors, destination, getter, setter, name);
                        continue;
                    }
                    this.addConverter(accessors, source, destination, getter, setter, name);
                }
                catch (Exception e) {
                    log.info("Getter ({}) on {} is not accessible!", (Object)getter.getName(), (Object)source.getCanonicalName());
                }
            }
        }
    }

    protected void addConverter(Map<String, TriFunction> accessors, Class<?> source, Class<?> destination, Method getter, Method setter, String name) {
        try {
            setter.setAccessible(true);
            Class<?> type = setter.getParameterTypes()[0];
            accessors.put(name, (s, d, w) -> {
                try {
                    Object value = getter.invoke(s, new Object[0]);
                    if (this.convert) {
                        setter.invoke(d, CodeFactory.create(MapperFactory.class, new Object[0]).convert(value, type));
                    } else {
                        setter.invoke(d, CodeFactory.create(MapperFactory.class, new Object[0]).map(value, type));
                    }
                    return d;
                }
                catch (Exception e) {
                    throw new MapperException("Unable to map value for field (" + name + ") for mapping (" + s.getClass().getCanonicalName() + "->" + d.getClass().getCanonicalName() + ")!", e);
                }
            });
        }
        catch (Exception e) {
            log.info("Setter ({}) on {} is not accessible!", (Object)setter.getName(), (Object)destination.getCanonicalName());
        }
    }

    protected void addConverterWither(Map<String, TriFunction> accessors, Class<?> source, Class<?> destination, Method getter, Method setter, String name) {
        try {
            setter.setAccessible(true);
            Class<?> type = setter.getParameterTypes()[0];
            accessors.put(name, (s, d, w) -> {
                try {
                    Object value = getter.invoke(s, new Object[0]);
                    if (this.convert) {
                        setter.invoke(w, CodeFactory.create(MapperFactory.class, new Object[0]).convert(value, type));
                    } else {
                        setter.invoke(w, CodeFactory.create(MapperFactory.class, new Object[0]).map(value, type));
                    }
                    return d;
                }
                catch (Exception e) {
                    throw new MapperException("Unable to map value for field (" + name + ") for mapping (" + s.getClass().getCanonicalName() + "->" + d.getClass().getCanonicalName() + ")!", e);
                }
            });
        }
        catch (Exception e) {
            log.info("Setter ({}) on {} is not accessible!", (Object)setter.getName(), (Object)destination.getCanonicalName());
        }
    }

    protected void addWither(Map<String, TriFunction> accessors, Method wither) {
        accessors.put("?!?wither?!?", (s, d, w) -> {
            try {
                return new WitherHolder(wither.invoke(d, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected boolean isNonNullableToNullable(Class<?> srcType, Class<?> destType) {
        if (srcType.isPrimitive()) {
            if (destType.equals(Double.class)) {
                return Double.TYPE.equals(srcType);
            }
            if (destType.equals(Float.class)) {
                return Float.TYPE.equals(srcType);
            }
            if (destType.equals(Long.class)) {
                return Long.TYPE.equals(srcType);
            }
            if (destType.equals(Integer.class)) {
                return Integer.TYPE.equals(srcType);
            }
            if (destType.equals(Short.class)) {
                return Short.TYPE.equals(srcType);
            }
            if (destType.equals(Character.class)) {
                return Character.TYPE.equals(srcType);
            }
            if (destType.equals(Byte.class)) {
                return Byte.TYPE.equals(srcType);
            }
            if (destType.equals(Boolean.class)) {
                return Boolean.TYPE.equals(srcType);
            }
        }
        return false;
    }

    protected boolean isNullableToNonNullable(Class<?> srcType, Class<?> destType) {
        if (destType.isPrimitive()) {
            if (srcType.equals(Double.class)) {
                return Double.TYPE.equals(destType);
            }
            if (srcType.equals(Float.class)) {
                return Float.TYPE.equals(destType);
            }
            if (srcType.equals(Long.class)) {
                return Long.TYPE.equals(destType);
            }
            if (srcType.equals(Integer.class)) {
                return Integer.TYPE.equals(destType);
            }
            if (srcType.equals(Short.class)) {
                return Short.TYPE.equals(destType);
            }
            if (srcType.equals(Character.class)) {
                return Character.TYPE.equals(destType);
            }
            if (srcType.equals(Byte.class)) {
                return Byte.TYPE.equals(destType);
            }
            if (srcType.equals(Boolean.class)) {
                return Boolean.TYPE.equals(destType);
            }
        }
        return false;
    }

    protected void addPlainGetterSetterMapping(Map<String, TriFunction> accessors, Class<?> destination, Method getter, Method setter, String name) {
        this.addGetterSetterMapping(accessors, destination, getter, setter, name, (v, d, s) -> {
            try {
                s.invoke(d, v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected void addPlainGetterWitherMapping(Map<String, TriFunction> accessors, Class<?> destination, Method getter, Method setter, String name) {
        this.addGetterWitherMapping(accessors, destination, getter, setter, name, (v, d, s) -> {
            try {
                s.invoke(d, v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected void addNullProtectedGetterSetterMapping(Map<String, TriFunction> accessors, Class<?> destination, Method getter, Method setter, String name) {
        this.addGetterSetterMapping(accessors, destination, getter, setter, name, (v, d, s) -> {
            try {
                if (Objects.nonNull(v)) {
                    s.invoke(d, v);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected void addNullProtectedGetterWitherMapping(Map<String, TriFunction> accessors, Class<?> destination, Method getter, Method setter, String name) {
        this.addGetterWitherMapping(accessors, destination, getter, setter, name, (v, d, s) -> {
            try {
                if (Objects.nonNull(v)) {
                    s.invoke(d, v);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected void addGetterSetterMapping(Map<String, TriFunction> accessors, Class<?> destination, Method getter, Method setter, String name, TriConsumer func) {
        try {
            setter.setAccessible(true);
            accessors.put(name, (s, d, w) -> {
                try {
                    Object value = getter.invoke(s, new Object[0]);
                    func.accept(value, d, setter);
                    return d;
                }
                catch (Exception e) {
                    throw new MapperException("Unable to map value for field (" + name + ") for mapping (" + s.getClass().getCanonicalName() + "->" + d.getClass().getCanonicalName() + ")!", e);
                }
            });
        }
        catch (Exception e) {
            log.info("Setter ({}) on {} is not accessible!", (Object)setter.getName(), (Object)destination.getCanonicalName());
        }
    }

    protected void addGetterWitherMapping(Map<String, TriFunction> accessors, Class<?> destination, Method getter, Method setter, String name, TriConsumer func) {
        try {
            setter.setAccessible(true);
            accessors.put(name, (s, d, w) -> {
                try {
                    Object value = getter.invoke(s, new Object[0]);
                    func.accept(value, w, setter);
                    return d;
                }
                catch (Exception e) {
                    throw new MapperException("Unable to map value for field (" + name + ") for mapping (" + s.getClass().getCanonicalName() + "->" + d.getClass().getCanonicalName() + ")!", e);
                }
            });
        }
        catch (Exception e) {
            log.info("Setter ({}) on {} is not accessible!", (Object)setter.getName(), (Object)destination.getCanonicalName());
        }
    }

    protected String getFieldName(String name) {
        int start = 3;
        if (name.charAt(0) == 'i') {
            start = 2;
        }
        StringBuilder result = new StringBuilder(name.substring(start));
        result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        return result.toString();
    }

    protected static interface TriFunction {
        public Object apply(Object var1, Object var2, Object var3);
    }

    @FunctionalInterface
    protected static interface TriConsumer {
        public void accept(Object var1, Object var2, Method var3);
    }

    protected static class WitherHolder {
        Object wither;

        public WitherHolder(Object wither) {
            this.wither = wither;
        }

        public Object get() {
            return this.wither;
        }
    }
}

