/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.collection;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.binis.codegen.collection.EmbeddedCodeCollection;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.modifier.Modifier;

public abstract class EmbeddedCodeCollectionImpl<M, T, R>
implements EmbeddedCodeCollection<M, T, R>,
Modifier<R> {
    private final Collection<T> collection;
    protected R parent;
    protected final Class<T> cls;

    protected EmbeddedCodeCollectionImpl(R parent, Collection<T> collection, Class<T> cls) {
        this.parent = parent;
        this.collection = collection;
        this.cls = cls;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _add(T value) {
        this.collection.add(value);
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _add(UnaryOperator<M> init) {
        T value = CodeFactory.create(this.cls);
        this.collection.add(value);
        init.apply(CodeFactory.modify(this, value, this.cls));
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _remove(T value) {
        this.collection.remove(value);
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _clear() {
        this.collection.clear();
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _each(Consumer<M> doWhat) {
        this.collection.forEach(e -> doWhat.accept(CodeFactory.modify(this, e, this.cls)));
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _ifEmpty(Consumer<EmbeddedCodeCollection<M, T, R>> doWhat) {
        if (this.collection.isEmpty()) {
            doWhat.accept(this);
        }
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _ifNotEmpty(Consumer<EmbeddedCodeCollection<M, T, R>> doWhat) {
        if (!this.collection.isEmpty()) {
            doWhat.accept(this);
        }
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _ifContains(T value, Consumer<EmbeddedCodeCollection<M, T, R>> doWhat) {
        if (this.collection.contains(value)) {
            doWhat.accept(this);
        }
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _ifContains(Predicate<T> predicate, Consumer<EmbeddedCodeCollection<M, T, R>> doWhat) {
        if (this.collection.stream().anyMatch(predicate)) {
            doWhat.accept(this);
        }
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _ifNotContains(T value, Consumer<EmbeddedCodeCollection<M, T, R>> doWhat) {
        if (!this.collection.contains(value)) {
            doWhat.accept(this);
        }
        return this;
    }

    @Override
    public EmbeddedCodeCollection<M, T, R> _ifNotContains(Predicate<T> predicate, Consumer<EmbeddedCodeCollection<M, T, R>> doWhat) {
        if (this.collection.stream().noneMatch(predicate)) {
            doWhat.accept(this);
        }
        return this;
    }

    @Override
    public M _add() {
        T value = CodeFactory.create(this.cls);
        this.collection.add(value);
        return CodeFactory.modify(this, value, this.cls);
    }

    @Override
    public Optional<M> _find(Predicate<T> predicate) {
        return this.collection.stream().filter(predicate).map(e -> CodeFactory.modify(this, e, this.cls)).findFirst();
    }

    @Override
    public List<M> _findAll(Predicate<T> predicate) {
        return this.collection.stream().filter(predicate).map(e -> CodeFactory.modify(this, e, this.cls)).collect(Collectors.toList());
    }

    @Override
    public R done() {
        return this.parent;
    }

    @Override
    public Stream<T> _stream() {
        return this.collection.stream();
    }

    @Override
    public R getObject() {
        return this.parent;
    }

    @Override
    public void setObject(R object) {
        this.parent = object;
    }
}

