/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflection {
    private static final Logger log = LoggerFactory.getLogger(Reflection.class);

    private Reflection() {
    }

    public static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception | NoClassDefFoundError e) {
            return null;
        }
    }

    public static <T> T instantiate(Class<T> cls) {
        return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void initialize(String cls) {
        Reflection.instantiate(Class.forName(cls));
    }

    public static Field findField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static <T> T getFieldValue(Object obj, String name) {
        try {
            Field field = Reflection.findField(obj.getClass(), name);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            log.error("Unable to get value for field {} of {}", new Object[]{name, obj.getClass().getName(), e});
            return null;
        }
    }
}

