/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.binis.codegen.factory.EmbeddedEnvelopFactory;
import net.binis.codegen.factory.EmbeddedObjectFactory;
import net.binis.codegen.factory.EnvelopFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeFactory {
    private static final Logger log = LoggerFactory.getLogger(CodeFactory.class);
    private static final Map<Class<?>, RegistryEntry> registry = new HashMap();

    private CodeFactory() {
    }

    public static <T> T create(Class<T> cls) {
        RegistryEntry entry = registry.get(cls);
        if (entry != null) {
            return (T)entry.getImplFactory().create();
        }
        return null;
    }

    public static <T> T create(Class<T> cls, String defaultClass) {
        RegistryEntry entry = registry.get(cls);
        if (entry != null) {
            return (T)entry.getImplFactory().create();
        }
        try {
            Reflection.initialize(defaultClass);
            return CodeFactory.create(cls);
        }
        catch (Exception e) {
            log.error("Can't find class: {}", (Object)defaultClass);
            return null;
        }
    }

    public static <M, T, P> M modify(P parent, T value) {
        RegistryEntry entry = registry.get(value.getClass());
        if (entry != null) {
            return (M)entry.getModifierFactory().create(parent, value);
        }
        return null;
    }

    public static Class<?> lookup(Class<?> intf) {
        RegistryEntry entry = registry.get(intf);
        if (entry != null) {
            if (entry.getImplClass() == null) {
                entry.setImplClass(entry.getImplFactory().create().getClass());
            }
            return entry.getImplClass();
        }
        return null;
    }

    public static void registerType(Class<?> intf, ObjectFactory impl, EmbeddedObjectFactory modifier) {
        if (!registry.containsKey(intf)) {
            registry.put(intf, RegistryEntry.builder().implFactory(impl).modifierFactory(modifier).build());
        }
    }

    public static void forceRegisterType(Class<?> intf, ObjectFactory impl, EmbeddedObjectFactory modifier) {
        registry.put(intf, RegistryEntry.builder().implFactory(impl).modifierFactory(modifier).build());
    }

    public static void envelopType(Class<?> intf, EnvelopFactory impl, EmbeddedEnvelopFactory modifier) {
        EmbeddedObjectFactory embeddedFactory;
        RegistryEntry reg = registry.get(intf);
        ObjectFactory implFactory = reg.getImplFactory();
        reg.setImplFactory(() -> impl.envelop(implFactory));
        if (Objects.nonNull(reg.getModifierFactory()) && Objects.nonNull(embeddedFactory = reg.getModifierFactory()) && Objects.nonNull(modifier)) {
            reg.setModifierFactory((parent, value) -> modifier.envelop(embeddedFactory, parent, value));
        }
    }

    public static ObjectFactory singleton(Object object) {
        return () -> object;
    }

    private static class RegistryEntry {
        private Class<?> implClass;
        private ObjectFactory implFactory;
        private EmbeddedObjectFactory modifierFactory;

        RegistryEntry(Class<?> implClass, ObjectFactory implFactory, EmbeddedObjectFactory modifierFactory) {
            this.implClass = implClass;
            this.implFactory = implFactory;
            this.modifierFactory = modifierFactory;
        }

        public static RegistryEntryBuilder builder() {
            return new RegistryEntryBuilder();
        }

        public Class<?> getImplClass() {
            return this.implClass;
        }

        public ObjectFactory getImplFactory() {
            return this.implFactory;
        }

        public EmbeddedObjectFactory getModifierFactory() {
            return this.modifierFactory;
        }

        public void setImplClass(Class<?> implClass) {
            this.implClass = implClass;
        }

        public void setImplFactory(ObjectFactory implFactory) {
            this.implFactory = implFactory;
        }

        public void setModifierFactory(EmbeddedObjectFactory modifierFactory) {
            this.modifierFactory = modifierFactory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegistryEntry)) {
                return false;
            }
            RegistryEntry other = (RegistryEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$implClass = this.getImplClass();
            Class<?> other$implClass = other.getImplClass();
            if (this$implClass == null ? other$implClass != null : !this$implClass.equals(other$implClass)) {
                return false;
            }
            ObjectFactory this$implFactory = this.getImplFactory();
            ObjectFactory other$implFactory = other.getImplFactory();
            if (this$implFactory == null ? other$implFactory != null : !this$implFactory.equals(other$implFactory)) {
                return false;
            }
            EmbeddedObjectFactory this$modifierFactory = this.getModifierFactory();
            EmbeddedObjectFactory other$modifierFactory = other.getModifierFactory();
            return !(this$modifierFactory == null ? other$modifierFactory != null : !this$modifierFactory.equals(other$modifierFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RegistryEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $implClass = this.getImplClass();
            result = result * 59 + ($implClass == null ? 43 : $implClass.hashCode());
            ObjectFactory $implFactory = this.getImplFactory();
            result = result * 59 + ($implFactory == null ? 43 : $implFactory.hashCode());
            EmbeddedObjectFactory $modifierFactory = this.getModifierFactory();
            result = result * 59 + ($modifierFactory == null ? 43 : $modifierFactory.hashCode());
            return result;
        }

        public String toString() {
            return "CodeFactory.RegistryEntry(implClass=" + this.getImplClass() + ", implFactory=" + this.getImplFactory() + ", modifierFactory=" + this.getModifierFactory() + ")";
        }

        public static class RegistryEntryBuilder {
            private Class<?> implClass;
            private ObjectFactory implFactory;
            private EmbeddedObjectFactory modifierFactory;

            RegistryEntryBuilder() {
            }

            public RegistryEntryBuilder implClass(Class<?> implClass) {
                this.implClass = implClass;
                return this;
            }

            public RegistryEntryBuilder implFactory(ObjectFactory implFactory) {
                this.implFactory = implFactory;
                return this;
            }

            public RegistryEntryBuilder modifierFactory(EmbeddedObjectFactory modifierFactory) {
                this.modifierFactory = modifierFactory;
                return this;
            }

            public RegistryEntry build() {
                return new RegistryEntry(this.implClass, this.implFactory, this.modifierFactory);
            }

            public String toString() {
                return "CodeFactory.RegistryEntry.RegistryEntryBuilder(implClass=" + this.implClass + ", implFactory=" + this.implFactory + ", modifierFactory=" + this.modifierFactory + ")";
            }
        }
    }
}

