/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.annotation.processor;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.google.auto.service.AutoService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import net.binis.codegen.CodeGen;
import net.binis.codegen.annotation.CodeConfiguration;
import net.binis.codegen.annotation.CodePrototypeTemplate;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.discoverer.AnnotationDiscoverer;
import net.binis.codegen.discovery.Discoverer;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Parsables;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import net.binis.codegen.utils.CodeGenAnnotationProcessorUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Processor.class})
public class CodeGenAnnotationProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(CodeGenAnnotationProcessor.class);
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Filer filer;
    protected Messager messager;
    protected Map<String, String> options;
    protected List<Discoverer.DiscoveredService> discovered;
    protected JavaFileManager fileManager;
    protected File targetDir;
    protected Set<String> sourceRoots;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        log.info("Initializing CodeGenAnnotationProcessor...");
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.options = processingEnv.getOptions();
        Helpers.lookup.setProcessingEnvironment(processingEnv);
        this.fileManager = this.getFileManager(processingEnv);
    }

    protected JavaFileManager getFileManager(ProcessingEnvironment processingEnv) {
        try {
            JavaFileManager result = (JavaFileManager)Reflection.getFieldValue((Object)processingEnv, (String)"fileManager");
            if (Objects.nonNull(result)) {
                return result;
            }
            result = (JavaFileManager)Reflection.getFieldValue((Object)Proxy.getInvocationHandler(Reflection.getFieldValue((Object)Reflection.getFieldValue((Object)Proxy.getInvocationHandler(processingEnv), (String)"val$delegateTo"), (String)"fileManager")), (String)"val$wrapper");
            if (Objects.nonNull(result)) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!this.processed()) {
                ArrayList elements = new ArrayList();
                CodeFactory.registerType(CodeFactory.class, () -> elements);
                Helpers.lookup.setRoundEnvironment(roundEnv);
                this.externalLookup(roundEnv);
                Parsables files = Parsables.create();
                this.processConfigs(roundEnv);
                this.processTemplates(roundEnv, files);
                Structures.defaultProperties.keySet().stream().map(Reflection::loadClass).filter(Objects::nonNull).forEach(cls -> this.processAnnotation(roundEnv, files, (Class<? extends Annotation>)cls, elements));
                if (!files.isEmpty()) {
                    CodeGen.processSources((Parsables)files);
                    if (!CodeGenAnnotationProcessorUtils.isElementTest()) {
                        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isProcessed).filter(p -> !p.isNested() || Objects.isNull(p.getParentClassName())).forEach(this::saveParsed);
                        Helpers.lookup.custom().forEach(this::saveParsed);
                    }
                }
            } else {
                log.debug("Prototypes already processed!");
            }
        }
        catch (Exception e) {
            log.error("CodeGenAnnotationProcessor exception!", (Throwable)e);
        }
        return false;
    }

    protected void saveParsed(PrototypeDescription<ClassOrInterfaceDeclaration> p) {
        if (Objects.isNull(p.getCompiled())) {
            if (p.getProperties().isGenerateImplementation() && Objects.isNull(p.getProperties().getMixInClass())) {
                this.saveFile((CompilationUnit)p.getFiles().get(0), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), true));
            }
            if (p.getProperties().isGenerateInterface()) {
                this.saveFile((CompilationUnit)p.getFiles().get(1), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), false));
            }
            p.getCustomFiles().forEach((name, file) -> {
                if (Objects.nonNull(file.getJavaClass())) {
                    this.saveFile((CompilationUnit)file.getJavaClass().findCompilationUnit().get(), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), true));
                }
            });
        }
    }

    protected void processTemplates(RoundEnvironment roundEnv, Parsables files) {
        File file;
        if (Objects.nonNull(this.targetDir) && Objects.nonNull(this.sourceRoots) && (file = new File(this.targetDir.getAbsolutePath() + "/binis/annotations")).exists()) {
            AnnotationDiscoverer.findAnnotations((File)file).stream().filter(Discoverer.DiscoveredService::isTemplate).filter(a -> !Structures.defaultProperties.containsKey(a.getName())).forEach(template -> this.sourceRoots.forEach(root -> Tools.with((Object)this.classNameToFile((String)root, template.getName()), f -> {
                if (f.exists()) {
                    try {
                        String source = Files.readString(f.toPath(), Charset.defaultCharset());
                        ParseResult result = Helpers.lookup.getParser().parse(source);
                        if (result.isSuccessful()) {
                            CompilationUnit unit = (CompilationUnit)result.getResult().get();
                            TypeDeclaration patt8695$temp = unit.getType(0);
                            if (patt8695$temp instanceof AnnotationDeclaration) {
                                AnnotationDeclaration ann = (AnnotationDeclaration)patt8695$temp;
                                log.info("Processing template: {}", (Object)ann.getNameAsString());
                                Structures.registerTemplate((AnnotationDeclaration)ann);
                            }
                        } else {
                            log.error("Failed template processing ({}) with:", (Object)template.getName());
                        }
                    }
                    catch (Exception e) {
                        log.error("Unable to read {}", f);
                    }
                }
            })));
        }
        LinkedHashMap<String, Pair> templates = new LinkedHashMap<String, Pair>();
        roundEnv.getElementsAnnotatedWith(CodePrototypeTemplate.class).forEach(element -> Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(element, null, null), source -> {
            ParseResult result = Helpers.lookup.getParser().parse(source);
            if (result.isSuccessful()) {
                templates.put(element.toString(), Pair.of((Object)((CompilationUnit)result.getResult().get()), (Object)true));
            } else {
                log.error("Failed template processing ({}) with:", (Object)element.toString());
                result.getProblems().forEach(p -> log.error("    {}:{} {}", new Object[]{p.getCause().map(Object::toString).orElse(""), p.getMessage(), p.getLocation().map(Object::toString).orElse("")}));
            }
            AnnotationDiscoverer.writeTemplate((Filer)this.filer, (String)element.toString());
            Holder fileName = Holder.blank();
            roundEnv.getElementsAnnotatedWith((TypeElement)element).forEach(e -> Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(e, element, (Holder<String>)fileName), s -> files.file(s).add(e, element, (String)fileName.get())));
        }));
        Holder shouldBreak = Holder.of((Object)false);
        int lastRun = -1;
        Holder passes = Holder.of((Object)0);
        block0: while (!templates.isEmpty()) {
            if (lastRun == templates.size()) {
                if ((Integer)passes.get() > 2) break;
                passes.set((Object)((Integer)passes.get() + 1));
            } else {
                lastRun = templates.size();
                passes.set((Object)0);
            }
            for (Map.Entry entry : templates.entrySet()) {
                Optional<AnnotationDeclaration> ann = ((CompilationUnit)((Pair)entry.getValue()).getKey()).getChildNodes().stream().filter(AnnotationDeclaration.class::isInstance).map(AnnotationDeclaration.class::cast).filter(c -> c.getFullyQualifiedName().filter(templates::containsKey).isPresent()).findFirst();
                if (ann.isPresent() && ann.get().getAnnotations().stream().map(a -> Helpers.getExternalClassName((Node)((Node)ann.get()), (String)a.getNameAsString())).noneMatch(name -> {
                    Pair pair = (Pair)templates.get(name);
                    if (Objects.nonNull(pair)) {
                        return (Integer)passes.get() < 2 || (Boolean)pair.getValue() != false;
                    }
                    if (!Structures.defaultProperties.containsKey(name)) {
                        PrototypeDescription ext = Helpers.lookup.findExternal(name);
                        if (Objects.nonNull(ext)) {
                            templates.put((String)name, Pair.of((Object)ext.getDeclarationUnit(), (Object)false));
                            shouldBreak.set((Object)true);
                            return true;
                        }
                    } else if (!((Boolean)((Pair)entry.getValue()).getValue()).booleanValue()) {
                        entry.setValue(Pair.of((Object)((CompilationUnit)((Pair)entry.getValue()).getKey()), (Object)true));
                        shouldBreak.set((Object)true);
                    }
                    return false;
                }) && ((Boolean)((Pair)entry.getValue()).getValue()).booleanValue()) {
                    CodeGen.processTemplate((String)ann.get().getNameAsString(), (CompilationUnit)((CompilationUnit)((Pair)entry.getValue()).getKey()));
                    templates.remove(entry.getKey());
                    shouldBreak.set((Object)true);
                }
                if (!((Boolean)shouldBreak.get()).booleanValue()) continue;
                shouldBreak.set((Object)false);
                continue block0;
            }
        }
        templates.forEach((name, pair) -> {
            if (((Boolean)pair.getValue()).booleanValue()) {
                log.warn("Possible template not processed: {}", name);
            }
        });
    }

    protected void processConfigs(RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(CodeConfiguration.class).forEach(element -> AnnotationDiscoverer.writeConfig((Filer)this.filer, (String)element.toString()));
    }

    protected boolean processed() {
        if (CodeGenAnnotationProcessorUtils.isPrototypeTest()) {
            return true;
        }
        try {
            return new File(this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "codegen.info").getName()).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void externalLookup(RoundEnvironment roundEnv) {
        Object object;
        Method method;
        HashSet<String> roots = new HashSet<String>();
        if (Objects.nonNull(this.fileManager) && Objects.nonNull(method = Reflection.findMethod((String)"getLocation", this.fileManager.getClass(), (Class[])new Class[]{JavaFileManager.Location.class})) && (object = Reflection.invoke((Method)method, (Object)this.fileManager, (Object[])new Object[]{StandardLocation.SOURCE_PATH})) instanceof Iterable) {
            Iterable files = (Iterable)object;
            files.forEach(f -> {
                if (f instanceof File) {
                    File file = (File)f;
                    String path = file.getAbsolutePath();
                    roots.add(path);
                    if (Objects.isNull(this.sourceRoots)) {
                        log.info("Sources Root: {}", (Object)path);
                    }
                }
            });
            Object object2 = Reflection.invoke((Method)method, (Object)this.fileManager, (Object[])new Object[]{StandardLocation.CLASS_OUTPUT});
            if (object2 instanceof Iterable) {
                Iterable targets = (Iterable)object2;
                this.targetDir = (File)targets.iterator().next();
            }
        }
        if (roots.isEmpty()) {
            List<Element> rootElements = roundEnv.getRootElements().stream().filter(TypeElement.class::isInstance).toList();
            rootElements.forEach(e -> {
                Object source = this.getSourceFile((Element)e);
                if (source instanceof FileObject) {
                    FileObject fileObject = (FileObject)source;
                    try {
                        File file = new File(fileObject.toUri());
                        while (Objects.nonNull(file.getParent())) {
                            if (!"java".equals((file = file.getParentFile()).getName())) continue;
                            String root = file.getAbsolutePath();
                            roots.add(root);
                            if (Objects.isNull(this.sourceRoots)) {
                                log.info("Sources Root: {}", (Object)root);
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        Helpers.lookup.registerExternalLookup(s -> {
            Optional<TypeElement> ext = roundEnv.getRootElements().stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).filter(e -> e.getQualifiedName().toString().equals(s)).findFirst();
            if (ext.isPresent()) {
                Object source = this.getSourceFile(ext.get());
                log.info("Accessing: {}", (Object)ext.get().getSimpleName());
                try {
                    return ((FileObject)source).getCharContent(true).toString();
                }
                catch (Exception ex) {
                    log.error("Unable to read {}", (Object)ext.get());
                }
            } else if (!roots.isEmpty()) {
                for (String root : roots) {
                    File file = this.classNameToFile(root, (String)s);
                    if (!file.exists()) continue;
                    try {
                        return Files.readString(file.toPath(), Charset.defaultCharset());
                    }
                    catch (Exception ex) {
                        log.error("Unable to read {}", (Object)file);
                    }
                }
            }
            return null;
        });
        this.sourceRoots = roots;
        Helpers.lookup.setSourcesRoots(roots);
    }

    protected File classNameToFile(String root, String className) {
        return new File(root + "/" + className.replace(".", "/") + ".java");
    }

    protected Object getSourceFile(Element element) {
        Object source = Reflection.getFieldValueUnsafe((Object)element, (String)"sourcefile");
        if (Objects.isNull(source)) {
            return Reflection.getFieldValue((Object)element, (String)"sourcefile");
        }
        return source;
    }

    protected void processAnnotation(RoundEnvironment roundEnv, Parsables files, Class<? extends Annotation> cls, List<Element> elements) {
        for (Element element : roundEnv.getElementsAnnotatedWith(cls)) {
            Holder fileName = Holder.blank();
            elements.add(element);
            Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(element, cls, (Holder<String>)fileName), source -> files.file(source).add(type, (Object)cls, (String)fileName.get()));
        }
    }

    protected static String readElementSource(Element eType, Object annotation, Holder<String> fileName) {
        Element type = CodeGenAnnotationProcessor.findClassType(eType);
        try {
            JavaFileObject source = (JavaFileObject)Reflection.getFieldValueUnsafe((Object)type, (String)"sourcefile");
            if (Objects.isNull(source)) {
                source = (JavaFileObject)Reflection.getFieldValue((Object)type, (String)"sourcefile");
            }
            log.info("Processing: {} ({}: {}{})", new Object[]{type.getSimpleName(), eType.getKind(), eType.getSimpleName().toString(), Objects.nonNull(annotation) ? " - @" + CodeGenAnnotationProcessor.calcAnnotationName(annotation) : ""});
            if (Objects.nonNull(fileName)) {
                try {
                    fileName.set((Object)source.toUri().toString());
                }
                catch (Exception e) {
                    fileName.set((Object)"<unknown>");
                }
            }
            return source.getCharContent(true).toString();
        }
        catch (Exception e) {
            log.error("Unable to process {}", (Object)type);
            return null;
        }
    }

    protected static String calcAnnotationName(Object annotation) {
        if (annotation instanceof Class) {
            Class cls = (Class)annotation;
            return cls.getSimpleName();
        }
        if ("com.sun.tools.javac.code.Symbol.ClassSymbol".equals(annotation.getClass().getCanonicalName())) {
            return new CGSymbol(annotation).getName();
        }
        return "unknown";
    }

    protected static Element findClassType(Element type) {
        if (Tools.in((Object)((Object)type.getKind()), (Object[])new ElementKind[]{ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.ENUM})) {
            return type;
        }
        if (Objects.nonNull(type = type.getEnclosingElement())) {
            return CodeGenAnnotationProcessor.findClassType(type);
        }
        return null;
    }

    protected void saveFile(CompilationUnit unit, String path) {
        block16: {
            if (Objects.nonNull(unit)) {
                TypeDeclaration type = unit.getType(0);
                try {
                    CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
                    Helpers.sortImports((CompilationUnit)unit);
                    if (unit.getType(0).isClassOrInterfaceDeclaration()) {
                        Helpers.sortClass((ClassOrInterfaceDeclaration)unit.getType(0).asClassOrInterfaceDeclaration());
                    }
                    if (Objects.isNull(path)) {
                        try (OutputStream stream = this.filer.createSourceFile((CharSequence)type.getFullyQualifiedName().get(), new Element[0]).openOutputStream();){
                            log.info("Writing file - {}", type.getFullyQualifiedName().get());
                            try (PrintWriter writer = new PrintWriter(stream);){
                                writer.write(printer.print((Node)unit));
                                break block16;
                            }
                        }
                    }
                    unit.getPackageDeclaration().ifPresent(p -> {
                        String fileName = path + "/" + p.getNameAsString().replace(".", "/") + "/" + unit.getType(0).getNameAsString() + ".java";
                        log.info("Writing file - {}", (Object)fileName);
                        File f = new File(fileName);
                        if (f.getParentFile().exists() || f.getParentFile().mkdirs()) {
                            try {
                                BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                                writer.write(printer.print((Node)unit));
                                writer.close();
                            }
                            catch (IOException e) {
                                log.error("Unable to open for write file {}", (Object)fileName);
                            }
                        } else {
                            log.error("Unable to write file {}", (Object)fileName);
                        }
                    });
                }
                catch (Exception e) {
                    throw new GenericCodeGenException("Unable to save " + (String)type.getFullyQualifiedName().get(), e);
                }
            }
        }
    }

    protected static String getBasePath(PrototypeData properties, boolean implementation) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)properties.getBasePath())) {
            result = properties.getBasePath();
        }
        if (implementation) {
            if (StringUtils.isNotBlank((CharSequence)properties.getImplementationPath())) {
                result = properties.getImplementationPath();
            }
        } else if (StringUtils.isNotBlank((CharSequence)properties.getInterfacePath())) {
            result = properties.getInterfacePath();
        }
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        this.discovered = AnnotationDiscoverer.findAnnotations();
        this.discovered.stream().filter(Discoverer.DiscoveredService::isTemplate).forEach(a -> Structures.registerTemplate((Class)a.getCls()));
        HashSet<String> result = new HashSet<String>(Structures.defaultProperties.keySet());
        result.add(CodePrototypeTemplate.class.getCanonicalName());
        result.add(CodeConfiguration.class.getCanonicalName());
        return result;
    }

    protected void error(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    static {
        CodeGenAnnotationProcessorUtils.addOpensForCodeGen((boolean)true);
        CodeFactory.registerType(ProcessingEnvironment.class, params -> CodeGenAnnotationProcessorUtils.getJavacProcessingEnvironment((ProcessingEnvironment)Helpers.lookup.getProcessingEnvironment(), (Object)Helpers.lookup.getProcessingEnvironment()));
    }
}

