/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.annotation.processor.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import net.binis.codegen.annotation.processor.CodeGenAnnotationProcessor;
import net.binis.codegen.annotation.processor.utils.dummy.Parent;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class CodeGenAnnotationProcessorUtils {
    private static final Logger log = LoggerFactory.getLogger(CodeGenAnnotationProcessorUtils.class);

    public static void addOpensForCodeGen() {
        Class<?> cModule;
        try {
            cModule = Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Unsafe unsafe = Reflection.getUnsafe();
        Object jdkCompilerModule = CodeGenAnnotationProcessorUtils.getJdkCompilerModule();
        Object ownModule = CodeGenAnnotationProcessorUtils.getOwnModule();
        String[] allPkgs = new String[]{"com.sun.tools.javac.code", "com.sun.tools.javac.comp", "com.sun.tools.javac.file", "com.sun.tools.javac.main", "com.sun.tools.javac.model", "com.sun.tools.javac.parser", "com.sun.tools.javac.processing", "com.sun.tools.javac.tree", "com.sun.tools.javac.util", "com.sun.tools.javac.jvm"};
        try {
            Method m = cModule.getDeclaredMethod("implAddOpens", String.class, cModule);
            long firstFieldOffset = CodeGenAnnotationProcessorUtils.getFirstFieldOffset(unsafe);
            unsafe.putBooleanVolatile(m, firstFieldOffset, true);
            for (String p : allPkgs) {
                m.invoke(jdkCompilerModule, p, ownModule);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static long getFirstFieldOffset(Unsafe unsafe) {
        try {
            return unsafe.objectFieldOffset(Parent.class.getDeclaredField("first"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getJdkCompilerModule() {
        try {
            Class<?> cModuleLayer = Class.forName("java.lang.ModuleLayer");
            Method mBoot = cModuleLayer.getDeclaredMethod("boot", new Class[0]);
            Object bootLayer = mBoot.invoke(null, new Object[0]);
            Class<?> cOptional = Class.forName("java.util.Optional");
            Method mFindModule = cModuleLayer.getDeclaredMethod("findModule", String.class);
            Object oCompilerO = mFindModule.invoke(bootLayer, "jdk.compiler");
            return cOptional.getDeclaredMethod("get", new Class[0]).invoke(oCompilerO, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getOwnModule() {
        try {
            Method m = Reflection.findMethod((String)"getModule", Class.class, (Class[])new Class[0]);
            return m.invoke(CodeGenAnnotationProcessor.class, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getJavacProcessingEnvironment(ProcessingEnvironment processingEnv, Object procEnv) {
        Class cls = Reflection.loadClass((String)"com.sun.tools.javac.processing.JavacProcessingEnvironment");
        if (Objects.nonNull(cls)) {
            if (cls.isAssignableFrom(procEnv.getClass())) {
                return procEnv;
            }
            for (Class<?> procEnvClass = procEnv.getClass(); procEnvClass != null; procEnvClass = procEnvClass.getSuperclass()) {
                Object delegate = CodeGenAnnotationProcessorUtils.tryGetDelegateField(procEnvClass, procEnv);
                if (delegate == null) {
                    delegate = CodeGenAnnotationProcessorUtils.tryGetProxyDelegateToField(procEnvClass, procEnv);
                }
                if (delegate == null) {
                    delegate = CodeGenAnnotationProcessorUtils.tryGetProcessingEnvField(procEnvClass, procEnv);
                }
                if (delegate == null) continue;
                return CodeGenAnnotationProcessorUtils.getJavacProcessingEnvironment(processingEnv, delegate);
            }
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't get the delegate of the gradle IncrementalProcessingEnvironment. Lombok won't work.");
        }
        return null;
    }

    private static Object tryGetDelegateField(Class<?> delegateClass, Object instance) {
        try {
            return Reflection.getFieldValue((Object)instance, (String)"delegate");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object tryGetProxyDelegateToField(Class<?> delegateClass, Object instance) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(instance);
            return Reflection.getFieldValue((Object)handler, (String)"val$delegateTo");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object tryGetProcessingEnvField(Class<?> delegateClass, Object instance) {
        try {
            return Reflection.getFieldValue(delegateClass, (Object)instance, (String)"processingEnv");
        }
        catch (Exception e) {
            return null;
        }
    }
}

