/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.annotation.processor;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.google.auto.service.AutoService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import net.binis.codegen.CodeGen;
import net.binis.codegen.annotation.CodeConfiguration;
import net.binis.codegen.annotation.CodePrototypeTemplate;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.discoverer.AnnotationDiscoverer;
import net.binis.codegen.discovery.Discoverer;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Parsables;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.tools.Holder;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import net.binis.codegen.utils.CodeGenAnnotationProcessorUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Processor.class})
public class CodeGenAnnotationProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(CodeGenAnnotationProcessor.class);
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Filer filer;
    protected Messager messager;
    protected Map<String, String> options;
    protected List<Discoverer.DiscoveredService> discovered;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        log.info("Initializing CodeGenAnnotationProcessor...");
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.options = processingEnv.getOptions();
        Helpers.lookup.setProcessingEnvironment(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!this.processed()) {
                Helpers.lookup.setRoundEnvironment(roundEnv);
                this.externalLookup(roundEnv);
                Parsables files = Parsables.create();
                this.processConfigs(roundEnv);
                this.processTemplates(roundEnv, files);
                Structures.defaultProperties.keySet().stream().map(Reflection::loadClass).filter(Objects::nonNull).forEach(cls -> this.processAnnotation(roundEnv, files, (Class<? extends Annotation>)cls));
                if (!files.isEmpty()) {
                    CodeGen.processSources((Parsables)files);
                    if (!CodeGenAnnotationProcessor.isElementTest()) {
                        Helpers.lookup.parsed().stream().filter(PrototypeDescription::isProcessed).filter(p -> !p.isNested() || Objects.isNull(p.getParentClassName())).forEach(this::saveParsed);
                        Helpers.lookup.custom().forEach(this::saveParsed);
                    }
                }
            } else {
                log.debug("Prototypes already processed!");
            }
        }
        catch (Exception e) {
            log.error("CodeGenAnnotationProcessor exception!", (Throwable)e);
        }
        return false;
    }

    protected void saveParsed(PrototypeDescription<ClassOrInterfaceDeclaration> p) {
        if (Objects.isNull(p.getCompiled())) {
            if (p.getProperties().isGenerateImplementation() && Objects.isNull(p.getProperties().getMixInClass())) {
                this.saveFile((CompilationUnit)p.getFiles().get(0), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), true));
            }
            if (p.getProperties().isGenerateInterface()) {
                this.saveFile((CompilationUnit)p.getFiles().get(1), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), false));
            }
            p.getCustomFiles().forEach((name, file) -> {
                if (Objects.nonNull(file.getJavaClass())) {
                    this.saveFile((CompilationUnit)file.getJavaClass().findCompilationUnit().get(), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), true));
                }
            });
        }
    }

    protected void processTemplates(RoundEnvironment roundEnv, Parsables files) {
        LinkedHashMap<String, Pair> templates = new LinkedHashMap<String, Pair>();
        roundEnv.getElementsAnnotatedWith(CodePrototypeTemplate.class).forEach(element -> Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(element, null), source -> {
            ParseResult result = Helpers.lookup.getParser().parse(source);
            if (result.isSuccessful()) {
                templates.put(element.toString(), Pair.of((Object)((CompilationUnit)result.getResult().get()), (Object)true));
            } else {
                log.error("Failed template processing ({}) with:", (Object)element.toString());
                result.getProblems().forEach(p -> log.error("    {}:{} {}", new Object[]{p.getCause().map(Object::toString).orElse(""), p.getMessage(), p.getLocation().map(Object::toString).orElse("")}));
            }
            AnnotationDiscoverer.writeTemplate((Filer)this.filer, (String)element.toString());
            roundEnv.getElementsAnnotatedWith((TypeElement)element).forEach(e -> Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(e, element), s -> files.file(s).add(e, element)));
        }));
        Holder shouldBreak = Holder.of((Object)false);
        int lastRun = -1;
        Holder passes = Holder.of((Object)0);
        block0: while (!templates.isEmpty()) {
            if (lastRun == templates.size()) {
                if ((Integer)passes.get() > 2) break;
                passes.set((Object)((Integer)passes.get() + 1));
            } else {
                lastRun = templates.size();
                passes.set((Object)0);
            }
            for (Map.Entry entry : templates.entrySet()) {
                Optional<AnnotationDeclaration> ann = ((CompilationUnit)((Pair)entry.getValue()).getKey()).getChildNodes().stream().filter(AnnotationDeclaration.class::isInstance).map(AnnotationDeclaration.class::cast).filter(c -> c.getFullyQualifiedName().filter(templates::containsKey).isPresent()).findFirst();
                if (ann.isPresent() && ann.get().getAnnotations().stream().map(a -> Helpers.getExternalClassName((Node)((Node)ann.get()), (String)a.getNameAsString())).noneMatch(name -> {
                    Pair pair = (Pair)templates.get(name);
                    if (Objects.nonNull(pair)) {
                        return (Integer)passes.get() < 2 || (Boolean)pair.getValue() != false;
                    }
                    if (!Structures.defaultProperties.containsKey(name)) {
                        PrototypeDescription ext = Helpers.lookup.findExternal(name);
                        if (Objects.nonNull(ext)) {
                            templates.put((String)name, Pair.of((Object)ext.getDeclarationUnit(), (Object)false));
                            shouldBreak.set((Object)true);
                            return true;
                        }
                    } else if (!((Boolean)((Pair)entry.getValue()).getValue()).booleanValue()) {
                        entry.setValue(Pair.of((Object)((CompilationUnit)((Pair)entry.getValue()).getKey()), (Object)true));
                        shouldBreak.set((Object)true);
                    }
                    return false;
                }) && ((Boolean)((Pair)entry.getValue()).getValue()).booleanValue()) {
                    CodeGen.processTemplate((String)ann.get().getNameAsString(), (CompilationUnit)((CompilationUnit)((Pair)entry.getValue()).getKey()));
                    templates.remove(entry.getKey());
                    shouldBreak.set((Object)true);
                }
                if (!((Boolean)shouldBreak.get()).booleanValue()) continue;
                shouldBreak.set((Object)false);
                continue block0;
            }
        }
        templates.forEach((name, pair) -> {
            if (((Boolean)pair.getValue()).booleanValue()) {
                log.warn("Possible template not processed: {}", name);
            }
        });
    }

    protected void processConfigs(RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(CodeConfiguration.class).forEach(element -> AnnotationDiscoverer.writeConfig((Filer)this.filer, (String)element.toString()));
    }

    protected boolean processed() {
        if (CodeGenAnnotationProcessor.isPrototypeTest()) {
            return true;
        }
        try {
            return new File(this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "codegen.info").getName()).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static boolean isPrototypeTest() {
        Class cls = Reflection.loadClass((String)"net.binis.codegen.test.BaseCodeGenTest");
        return Objects.nonNull(cls) && Objects.nonNull(CodeFactory.create((Class)cls, (Object[])new Object[0]));
    }

    protected static boolean isElementTest() {
        Class cls = Reflection.loadClass((String)"net.binis.codegen.test.BaseCodeGenElementTest");
        return Objects.nonNull(cls) && Objects.nonNull(CodeFactory.create((Class)cls, (Object[])new Object[0]));
    }

    protected void externalLookup(RoundEnvironment roundEnv) {
        Helpers.lookup.registerExternalLookup(s -> {
            Optional<TypeElement> ext = roundEnv.getRootElements().stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).filter(e -> e.getQualifiedName().toString().equals(s)).findFirst();
            if (ext.isPresent()) {
                Object source = Reflection.getFieldValueUnsafe((Object)ext.get(), (String)"sourcefile");
                if (Objects.isNull(source)) {
                    source = Reflection.getFieldValue((Object)ext.get(), (String)"sourcefile");
                }
                log.info("Accessing: {}", (Object)ext.get().getSimpleName());
                try {
                    return ((FileObject)source).getCharContent(true).toString();
                }
                catch (Exception ex) {
                    log.error("Unable to read {}", (Object)ext.get());
                }
            }
            return null;
        });
    }

    protected void processAnnotation(RoundEnvironment roundEnv, Parsables files, Class<? extends Annotation> cls) {
        for (Element element : roundEnv.getElementsAnnotatedWith(cls)) {
            Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(element, cls), source -> files.file(source).add(type, (Object)cls));
        }
    }

    protected static String readElementSource(Element eType, Object annotation) {
        Element type = CodeGenAnnotationProcessor.findClassType(eType);
        try {
            JavaFileObject source = (JavaFileObject)Reflection.getFieldValueUnsafe((Object)type, (String)"sourcefile");
            if (Objects.isNull(source)) {
                source = (JavaFileObject)Reflection.getFieldValue((Object)type, (String)"sourcefile");
            }
            log.info("Processing: {} ({}: {}{})", new Object[]{type.getSimpleName(), eType.getKind(), eType.getSimpleName().toString(), Objects.nonNull(annotation) ? " - @" + CodeGenAnnotationProcessor.calcAnnotationName(annotation) : ""});
            return source.getCharContent(true).toString();
        }
        catch (Exception e) {
            log.error("Unable to process {}", (Object)type);
            return null;
        }
    }

    protected static String calcAnnotationName(Object annotation) {
        if (annotation instanceof Class) {
            Class cls = (Class)annotation;
            return cls.getSimpleName();
        }
        if ("com.sun.tools.javac.code.Symbol.ClassSymbol".equals(annotation.getClass().getCanonicalName())) {
            return new CGSymbol(annotation).getName();
        }
        return "unknown";
    }

    protected static Element findClassType(Element type) {
        if (Tools.in((Object)((Object)type.getKind()), (Object[])new ElementKind[]{ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.ENUM})) {
            return type;
        }
        if (Objects.nonNull(type = type.getEnclosingElement())) {
            return CodeGenAnnotationProcessor.findClassType(type);
        }
        return null;
    }

    protected void saveFile(CompilationUnit unit, String path) {
        block16: {
            if (Objects.nonNull(unit)) {
                TypeDeclaration type = unit.getType(0);
                try {
                    CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
                    Helpers.sortImports((CompilationUnit)unit);
                    if (unit.getType(0).isClassOrInterfaceDeclaration()) {
                        Helpers.sortClass((ClassOrInterfaceDeclaration)unit.getType(0).asClassOrInterfaceDeclaration());
                    }
                    if (Objects.isNull(path)) {
                        try (OutputStream stream = this.filer.createSourceFile((CharSequence)type.getFullyQualifiedName().get(), new Element[0]).openOutputStream();){
                            log.info("Writing file - {}", type.getFullyQualifiedName().get());
                            try (PrintWriter writer = new PrintWriter(stream);){
                                writer.write(printer.print((Node)unit));
                                break block16;
                            }
                        }
                    }
                    unit.getPackageDeclaration().ifPresent(p -> {
                        String fileName = path + "/" + p.getNameAsString().replace(".", "/") + "/" + unit.getType(0).getNameAsString() + ".java";
                        log.info("Writing file - {}", (Object)fileName);
                        File f = new File(fileName);
                        if (f.getParentFile().exists() || f.getParentFile().mkdirs()) {
                            try {
                                BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                                writer.write(printer.print((Node)unit));
                                writer.close();
                            }
                            catch (IOException e) {
                                log.error("Unable to open for write file {}", (Object)fileName);
                            }
                        } else {
                            log.error("Unable to write file {}", (Object)fileName);
                        }
                    });
                }
                catch (Exception e) {
                    throw new GenericCodeGenException("Unable to save " + (String)type.getFullyQualifiedName().get(), e);
                }
            }
        }
    }

    protected static String getBasePath(PrototypeData properties, boolean implementation) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)properties.getBasePath())) {
            result = properties.getBasePath();
        }
        if (implementation) {
            if (StringUtils.isNotBlank((CharSequence)properties.getImplementationPath())) {
                result = properties.getImplementationPath();
            }
        } else if (StringUtils.isNotBlank((CharSequence)properties.getInterfacePath())) {
            result = properties.getInterfacePath();
        }
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        this.discovered = AnnotationDiscoverer.findAnnotations();
        this.discovered.stream().filter(Discoverer.DiscoveredService::isTemplate).forEach(a -> Structures.registerTemplate((Class)a.getCls()));
        HashSet<String> result = new HashSet<String>(Structures.defaultProperties.keySet());
        result.add(CodePrototypeTemplate.class.getCanonicalName());
        result.add(CodeConfiguration.class.getCanonicalName());
        return result;
    }

    protected void error(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    static {
        CodeGenAnnotationProcessorUtils.addOpensForCodeGen((boolean)true);
        CodeFactory.registerType(ProcessingEnvironment.class, params -> CodeGenAnnotationProcessorUtils.getJavacProcessingEnvironment((ProcessingEnvironment)Helpers.lookup.getProcessingEnvironment(), (Object)Helpers.lookup.getProcessingEnvironment()));
    }
}

