/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.annotation.processor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.google.auto.service.AutoService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import net.binis.codegen.CodeGen;
import net.binis.codegen.annotation.CodeConfiguration;
import net.binis.codegen.annotation.CodePrototypeTemplate;
import net.binis.codegen.annotation.processor.utils.CodeGenAnnotationProcessorUtils;
import net.binis.codegen.discoverer.AnnotationDiscoverer;
import net.binis.codegen.discovery.Discoverer;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.generation.core.Helpers;
import net.binis.codegen.generation.core.Structures;
import net.binis.codegen.generation.core.interfaces.PrototypeData;
import net.binis.codegen.generation.core.interfaces.PrototypeDescription;
import net.binis.codegen.javaparser.CodeGenPrettyPrinter;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.tools.Tools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Processor.class})
public class CodeGenAnnotationProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(CodeGenAnnotationProcessor.class);
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;
    private Map<String, String> options;
    private List<Discoverer.DiscoveredService> discovered;

    public CodeGenAnnotationProcessor() {
        CodeGenAnnotationProcessorUtils.addOpensForCodeGen();
        CodeFactory.registerType(ProcessingEnvironment.class, params -> CodeGenAnnotationProcessorUtils.getJavacProcessingEnvironment(Helpers.lookup.getProcessingEnvironment(), Helpers.lookup.getProcessingEnvironment()));
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.options = processingEnv.getOptions();
        Helpers.lookup.setProcessingEnvironment(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!this.processed()) {
                Helpers.lookup.setRoundEnvironment(roundEnv);
                ArrayList<Pair<String, Element>> files = new ArrayList<Pair<String, Element>>();
                this.processConfigs(roundEnv);
                this.processTemplates(roundEnv, files);
                this.discovered.stream().filter(a -> "template".equals(a.getType())).forEach(a -> this.processAnnotation(roundEnv, files, a.getCls()));
                if (!files.isEmpty()) {
                    this.externalLookup(roundEnv);
                    CodeGen.processSources(files);
                    Helpers.lookup.parsed().stream().filter(PrototypeDescription::isProcessed).filter(p -> !p.isNested() || Objects.isNull(p.getParentClassName())).forEach(this::saveParsed);
                    Helpers.lookup.custom().forEach(this::saveParsed);
                }
            } else {
                log.debug("Prototypes already processed!");
            }
        }
        catch (Exception e) {
            log.error("CodeGenAnnotationProcessor exception!", (Throwable)e);
        }
        return false;
    }

    private void saveParsed(PrototypeDescription<ClassOrInterfaceDeclaration> p) {
        if (Objects.isNull(p.getCompiled())) {
            if (p.getProperties().isGenerateImplementation() && Objects.isNull(p.getProperties().getMixInClass())) {
                this.saveFile((CompilationUnit)p.getFiles().get(0), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), true));
            }
            if (p.getProperties().isGenerateInterface()) {
                this.saveFile((CompilationUnit)p.getFiles().get(1), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), false));
            }
            p.getCustomFiles().forEach((name, file) -> {
                if (Objects.nonNull(file.getJavaClass())) {
                    this.saveFile((CompilationUnit)file.getJavaClass().findCompilationUnit().get(), CodeGenAnnotationProcessor.getBasePath(p.getProperties(), true));
                }
            });
        }
    }

    private void processTemplates(RoundEnvironment roundEnv, List<Pair<String, Element>> files) {
        roundEnv.getElementsAnnotatedWith(CodePrototypeTemplate.class).forEach(element -> Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(element), source -> {
            CodeGen.processTemplate((String)element.getSimpleName().toString(), (String)source);
            AnnotationDiscoverer.writeTemplate((Filer)this.filer, (String)element.toString());
            roundEnv.getElementsAnnotatedWith((TypeElement)element).forEach(e -> Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(e), s -> files.add(Pair.of((Object)s, (Object)element))));
        }));
    }

    private void processConfigs(RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(CodeConfiguration.class).forEach(element -> AnnotationDiscoverer.writeConfig((Filer)this.filer, (String)element.toString()));
    }

    private boolean processed() {
        Class cls = Reflection.loadClass((String)"net.binis.codegen.test.BaseCodeGenTest");
        if (Objects.nonNull(cls) && Objects.nonNull(CodeFactory.create((Class)cls, (Object[])new Object[0]))) {
            return true;
        }
        try {
            return new File(this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "codegen.info").getName()).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void externalLookup(RoundEnvironment roundEnv) {
        Helpers.lookup.registerExternalLookup(s -> {
            Optional<TypeElement> ext = roundEnv.getRootElements().stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).filter(e -> e.getQualifiedName().toString().equals(s)).findFirst();
            if (ext.isPresent()) {
                Object source = Reflection.getFieldValueUnsafe((Object)ext.get(), (String)"sourcefile");
                if (Objects.isNull(source)) {
                    source = Reflection.getFieldValue((Object)ext.get(), (String)"sourcefile");
                }
                log.info("Accessing: {}", (Object)ext.get().getSimpleName());
                try {
                    return ((FileObject)source).getCharContent(true).toString();
                }
                catch (Exception ex) {
                    log.error("Unable to read {}", (Object)ext.get());
                }
            }
            return null;
        });
    }

    private void processAnnotation(RoundEnvironment roundEnv, List<Pair<String, Element>> files, Class<? extends Annotation> cls) {
        for (Element element : roundEnv.getElementsAnnotatedWith(cls)) {
            Tools.with((Object)CodeGenAnnotationProcessor.readElementSource(element), source -> files.add(Pair.of((Object)source, (Object)type)));
        }
    }

    private static String readElementSource(Element type) {
        if (ElementKind.METHOD.equals((Object)type.getKind())) {
            type = type.getEnclosingElement();
        }
        try {
            JavaFileObject source = (JavaFileObject)Reflection.getFieldValueUnsafe((Object)type, (String)"sourcefile");
            if (Objects.isNull(source)) {
                source = (JavaFileObject)Reflection.getFieldValue((Object)type, (String)"sourcefile");
            }
            log.info("Processing: {}", (Object)type.getSimpleName());
            return source.getCharContent(true).toString();
        }
        catch (Exception e) {
            log.error("Unable to process {}", (Object)type);
            return null;
        }
    }

    private void saveFile(CompilationUnit unit, String path) {
        block16: {
            if (Objects.nonNull(unit)) {
                TypeDeclaration type = unit.getType(0);
                try {
                    CodeGenPrettyPrinter printer = new CodeGenPrettyPrinter();
                    Helpers.sortImports((CompilationUnit)unit);
                    if (unit.getType(0).isClassOrInterfaceDeclaration()) {
                        Helpers.sortClass((ClassOrInterfaceDeclaration)unit.getType(0).asClassOrInterfaceDeclaration());
                    }
                    if (Objects.isNull(path)) {
                        try (OutputStream stream = this.filer.createSourceFile((CharSequence)type.getFullyQualifiedName().get(), new Element[0]).openOutputStream();){
                            log.info("Writing file - {}", type.getFullyQualifiedName().get());
                            try (PrintWriter writer = new PrintWriter(stream);){
                                writer.write(printer.print((Node)unit));
                                break block16;
                            }
                        }
                    }
                    unit.getPackageDeclaration().ifPresent(p -> {
                        String fileName = path + "/" + p.getNameAsString().replace(".", "/") + "/" + unit.getType(0).getNameAsString() + ".java";
                        log.info("Writing file - {}", (Object)fileName);
                        File f = new File(fileName);
                        if (f.getParentFile().exists() || f.getParentFile().mkdirs()) {
                            try {
                                BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                                writer.write(printer.print((Node)unit));
                                writer.close();
                            }
                            catch (IOException e) {
                                log.error("Unable to open for write file {}", (Object)fileName);
                            }
                        } else {
                            log.error("Unable to write file {}", (Object)fileName);
                        }
                    });
                }
                catch (Exception e) {
                    throw new GenericCodeGenException("Unable to save " + (String)type.getFullyQualifiedName().get(), e);
                }
            }
        }
    }

    private static String getBasePath(PrototypeData properties, boolean implementation) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)properties.getBasePath())) {
            result = properties.getBasePath();
        }
        if (implementation) {
            if (StringUtils.isNotBlank((CharSequence)properties.getImplementationPath())) {
                result = properties.getImplementationPath();
            }
        } else if (StringUtils.isNotBlank((CharSequence)properties.getInterfacePath())) {
            result = properties.getInterfacePath();
        }
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> result = new HashSet<String>();
        this.discovered = AnnotationDiscoverer.findAnnotations();
        this.discovered.stream().filter(Discoverer.DiscoveredService::isTemplate).forEach(a -> {
            result.add(a.getName());
            Structures.registerTemplate((Class)a.getCls());
        });
        result.add(CodePrototypeTemplate.class.getCanonicalName());
        result.add(CodeConfiguration.class.getCanonicalName());
        return result;
    }

    private void error(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }
}

