/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.mock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.mock.CodeGenMatcher;
import net.binis.codegen.mock.MockEntityManager;
import net.binis.codegen.mock.MockedQueryContext;
import net.binis.codegen.mock.MockedQueryContextImpl;
import net.binis.codegen.mock.exception.QueryAlreadyMockedException;
import net.binis.codegen.mock.exception.QueryCallsMismatchException;
import net.binis.codegen.mock.exception.QueryNotMockedException;
import net.binis.codegen.spring.AsyncEntityModifier;
import net.binis.codegen.spring.BasePersistenceOperations;
import net.binis.codegen.spring.async.AsyncExecutor;
import net.binis.codegen.spring.async.executor.CodeExecutor;
import net.binis.codegen.spring.component.ApplicationContextProvider;
import net.binis.codegen.spring.query.MockedQuery;
import net.binis.codegen.spring.query.Printable;
import net.binis.codegen.spring.query.QueryAccessor;
import net.binis.codegen.spring.query.QueryProcessor;
import net.binis.codegen.spring.query.Queryable;
import net.binis.codegen.tools.Reflection;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class CodeGenMock {
    private static final Logger log = LoggerFactory.getLogger(CodeGenMock.class);
    private static QueryProcessor.Processor mockedProcessor;
    private static final Map<String, MockedQueryContextImpl> mockedResponses;

    private CodeGenMock() {
    }

    public static void mockContext() {
        if (Objects.isNull(ApplicationContextProvider.getApplicationContext())) {
            ApplicationContext context = (ApplicationContext)Mockito.mock(ApplicationContext.class);
            JpaTransactionManager tm = (JpaTransactionManager)Mockito.mock(JpaTransactionManager.class);
            Mockito.when((Object)((JpaTransactionManager)context.getBean((Class)ArgumentMatchers.eq(JpaTransactionManager.class)))).thenReturn((Object)tm);
            Mockito.when((Object)tm.getEntityManagerFactory()).thenReturn((Object)((EntityManagerFactory)Mockito.mock(EntityManagerFactory.class)));
            TransactionTemplate template = (TransactionTemplate)Mockito.mock(TransactionTemplate.class);
            Mockito.when((Object)((TransactionTemplate)context.getBean((Class)ArgumentMatchers.eq(TransactionTemplate.class)))).thenReturn((Object)template);
            Mockito.when((Object)template.execute((TransactionCallback)ArgumentMatchers.any())).then(m -> ((TransactionCallback)m.getArgument(0)).doInTransaction(null));
            ApplicationContextProvider.setAppContext((ApplicationContext)context);
        }
    }

    public static void mockEntityManager() {
        MockEntityManager entityManager = new MockEntityManager();
        BasePersistenceOperations.setEntityManagerProvider(factory -> entityManager);
    }

    public static void mockAsyncExecutor() {
        Reflection.instantiate(AsyncEntityModifier.class);
        CodeFactory.forceRegisterType(AsyncExecutor.class, (ObjectFactory)CodeFactory.singleton((Object)CodeExecutor.syncExecutor()), null);
    }

    public static void mockContextAndEntityManager() {
        CodeGenMock.mockContext();
        CodeGenMock.mockEntityManager();
    }

    public static void mockQueryProcessor(BiFunction<String, List<Object>, Object> func) {
        QueryProcessor.setProcessor((executor, manager, query, params, resultType, resultClass, mapClass, isNative, isModifying, pagable, flush, lock, hints, filters) -> func.apply(query, params));
    }

    public static MockedQueryContext mockJustQuery(Printable query, Object returnObject) {
        return CodeGenMock.mockQuery(query.print(), null, returnObject);
    }

    public static MockedQueryContext mockJustQuery(Printable query, Supplier<Object> returnObject) {
        return CodeGenMock.mockQuery(query.print(), null, returnObject);
    }

    public static MockedQueryContext mockQuery(Printable query, List<Object> params, Object returnObject) {
        return CodeGenMock.mockQuery(query.print(), params, returnObject);
    }

    public static MockedQueryContext mockQuery(Printable query, List<Object> params, Supplier<Object> returnObject) {
        return CodeGenMock.mockQuery(query.print(), params, returnObject);
    }

    public static MockedQueryContext mockQuery(Queryable query, Object returnObject) {
        return CodeGenMock.mockQuery(query.print(), (List<Object>)((QueryAccessor)query).getParams(), returnObject);
    }

    public static MockedQueryContext mockQuery(Queryable query, Supplier<Object> returnObject) {
        return CodeGenMock.mockQuery(query.print(), (List<Object>)((QueryAccessor)query).getParams(), returnObject);
    }

    public static MockedQueryContext mockCountQuery(Queryable query, Long count) {
        return CodeGenMock.mockCountQuery(query, () -> count);
    }

    public static MockedQueryContext mockCountQuery(Queryable query, Supplier<Long> count) {
        Object q = query.print();
        q = ((String)q).startsWith("select u ") ? ((String)q).replace("select u ", "select count(*) ") : "select count(*) " + (String)q;
        return CodeGenMock.mockQuery((String)q, (List<Object>)((QueryAccessor)query).getParams(), count);
    }

    public static MockedQueryContext mockExistsQuery(Queryable query, boolean exists) {
        return CodeGenMock.mockCountQuery(query, exists ? 1L : 0L);
    }

    public static MockedQueryContext mockExistsQuery(Queryable query, BooleanSupplier exists) {
        Supplier<Long> result = () -> exists.getAsBoolean() ? 1L : 0L;
        return CodeGenMock.mockCountQuery(query, result);
    }

    public static MockedQueryContext mockQuery(String query, Object returnObject) {
        return CodeGenMock.mockQuery(query, null, returnObject);
    }

    public static MockedQueryContext mockQuery(String query, List<Object> params, Object returnObject) {
        MockedQueryContextImpl mocks;
        MockedQueryContextImpl.MockedQueryParams result = null;
        if (Objects.isNull(mockedProcessor) || !mockedProcessor.equals(QueryProcessor.getProcessor())) {
            QueryProcessor.setProcessor((QueryProcessor.Processor)CodeGenMock.createMockedProcessor());
        }
        if (Objects.nonNull(mocks = mockedResponses.get(query))) {
            Optional<MockedQueryContextImpl.MockedQueryParams> mock = CodeGenMock.findMock(query, params);
            if (mock.isEmpty()) {
                result = MockedQueryContextImpl.MockedQueryParams.builder().parent(mocks).params(params).returnObject(returnObject).build();
                mocks.getMocks().add(result);
            } else {
                result = mock.get();
                if (Objects.nonNull(mock.get().getParams())) {
                    if (mock.get().isFails()) {
                        CodeGenMock.logErrorAlreadyMocked(query, params);
                    } else {
                        CodeGenMock.logWarning(query, params);
                    }
                }
            }
        } else {
            result = MockedQueryContextImpl.MockedQueryParams.builder().params(params).returnObject(returnObject).build();
            mocks = MockedQueryContextImpl.builder().query(query).mock(result).build();
            result.withParent(mocks);
            mockedResponses.put(query, mocks);
        }
        return result;
    }

    public static void mockCheckCalls() {
        mockedResponses.forEach((key, value) -> value.getMocks().stream().filter(mock -> mock.getMatch() != mock.getExpected()).forEach(mock -> {
            if (mock.isFails()) {
                CodeGenMock.logError(key, mock.getParams(), mock.getMatch(), mock.getExpected());
            } else {
                CodeGenMock.logWarning(key, mock.getParams(), mock.getMatch(), mock.getExpected());
            }
        }));
    }

    public static void mockQueryClear() {
        mockedResponses.clear();
    }

    static QueryProcessor.Processor createMockedProcessor() {
        mockedProcessor = (executor, manager, query, params, resultType, resultClass, mapClass, isNative, isModifying, pagable, flush, lock, hints, filters) -> {
            PageImpl value;
            Optional<MockedQueryContextImpl.MockedQueryParams> mock = CodeGenMock.findMock(query, params);
            if (mock.isEmpty()) {
                CodeGenMock.logError(query, params);
            }
            if ((value = mock.get().getReturnObject()) instanceof Supplier) {
                value = ((Supplier)value).get();
            }
            mock.get().touch();
            switch (resultType) {
                case SINGLE: 
                case TUPLE: {
                    return Optional.ofNullable(value);
                }
                case COUNT: 
                case REMOVE: 
                case EXECUTE: {
                    return value;
                }
                case LIST: 
                case TUPLES: {
                    return value instanceof List ? value : List.of(value);
                }
                case PAGE: {
                    return value instanceof Page ? value : new PageImpl(value instanceof List ? (List<PageImpl>)value : List.of(value), pagable, Integer.MAX_VALUE);
                }
            }
            throw new GenericCodeGenException("Unknown query return type!");
        };
        return mockedProcessor;
    }

    private static Optional<MockedQueryContextImpl.MockedQueryParams> findMock(String query, List<Object> params) {
        MockedQueryContextImpl mocks = mockedResponses.get(query);
        if (Objects.isNull(mocks)) {
            return Optional.empty();
        }
        Optional<MockedQueryContextImpl.MockedQueryParams> mock = mocks.getMocks().stream().filter(p -> CodeGenMock.paramsEquals(p, params)).findFirst();
        if (mock.isEmpty()) {
            mock = mocks.getMocks().stream().filter(p -> Objects.isNull(p.getParams())).findFirst();
        }
        return mock;
    }

    private static boolean paramsEquals(MockedQueryContextImpl.MockedQueryParams pair, List<Object> params) {
        List<Object> mockParams = pair.getParams();
        if (Objects.nonNull(mockParams) && mockParams.size() == params.size()) {
            for (int i = 0; i < params.size(); ++i) {
                if ((!Objects.isNull(mockParams.get(i)) || !Objects.nonNull(params.get(i))) && (mockParams.get(i).equals(params.get(i)) || CodeGenMatcher.class.equals(mockParams.get(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void logError(String query, List<Object> params) {
        throw new QueryNotMockedException(CodeGenMock.logText(query, params) + " is not mocked!");
    }

    private static void logErrorAlreadyMocked(String query, List<Object> params) {
        throw new QueryAlreadyMockedException(CodeGenMock.logText(query, params) + " already mocked!");
    }

    private static void logError(String query, List<Object> params, int match, int expected) {
        throw new QueryCallsMismatchException(CodeGenMock.logText(query, params) + " calls mismatch! Expected: " + expected + ", Actual: " + match);
    }

    private static void logWarning(String query, List<Object> params) {
        log.warn("{} already mocked!", (Object)CodeGenMock.logText(query, params));
    }

    private static void logWarning(String query, List<Object> params, int match, int expected) {
        log.warn("{} calls mismatch! Expected: {}, Actual: {}", new Object[]{CodeGenMock.logText(query, params), match, expected});
    }

    private static String logText(String query, List<Object> params) {
        if (Objects.nonNull(params)) {
            return "Query '" + query + "' with params [" + params.stream().map(Object::toString).map(s -> "(" + s + ")").collect(Collectors.joining(", ")) + "]";
        }
        return "Query '" + query + "' with any params";
    }

    public static void mockCreate(Class<?> cls) {
        Reflection.instantiate(cls);
        CodeGenMock.findMocks(cls);
    }

    private static void findMocks(Class<?> cls) {
        CodeGenMock.findMock(cls);
        for (Class<?> i : cls.getInterfaces()) {
            CodeGenMock.findMocks(i);
        }
        for (Class<?> c : cls.getClasses()) {
            CodeGenMock.findMocks(c);
        }
    }

    private static void findMock(Class<?> i) {
        UnaryOperator mock = v -> {
            if (CodeGenMatcher.anyMock.get().booleanValue()) {
                CodeGenMatcher.anyMock.set(false);
                v = CodeGenMatcher.class;
            }
            return v;
        };
        UnaryOperator onValue = v -> {
            if (Objects.isNull(v) && CodeGenMatcher.anyMock.get().booleanValue()) {
                v = CodeGenMatcher.class;
                CodeGenMatcher.anyMock.set(false);
            }
            return v;
        };
        Class factory = CodeFactory.lookup(i);
        if (Objects.nonNull(factory)) {
            CodeFactory.envelopType(i, f -> {
                Object result = f.create();
                if (result instanceof MockedQuery) {
                    ((MockedQuery)result).setMocked(mock, onValue);
                }
                return result;
            }, (f, p, v) -> {
                Object result = f.create(p, v);
                if (result instanceof MockedQuery) {
                    ((MockedQuery)result).setMocked(mock, onValue);
                }
                return result;
            });
        }
    }

    static {
        mockedResponses = new HashMap<String, MockedQueryContextImpl>();
    }
}

