/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.mock.CodeGenMatcher;
import net.binis.codegen.mock.MockEntityManager;
import net.binis.codegen.mock.exception.QueryNotMockedException;
import net.binis.codegen.spring.AsyncEntityModifier;
import net.binis.codegen.spring.BasePersistenceOperations;
import net.binis.codegen.spring.async.AsyncExecutor;
import net.binis.codegen.spring.async.executor.CodeExecutor;
import net.binis.codegen.spring.component.ApplicationContextProvider;
import net.binis.codegen.spring.query.MockedQuery;
import net.binis.codegen.spring.query.Printable;
import net.binis.codegen.spring.query.QueryAccessor;
import net.binis.codegen.spring.query.QueryProcessor;
import net.binis.codegen.spring.query.Queryable;
import net.binis.codegen.tools.Reflection;
import org.apache.commons.lang3.tuple.Pair;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class CodeGenMock {
    private static final Logger log = LoggerFactory.getLogger(CodeGenMock.class);
    private static QueryProcessor.Processor mockedProcessor;
    private static final Map<String, List<Pair<List<Object>, Object>>> mockedResponses;

    private CodeGenMock() {
    }

    public static void mockContext() {
        if (Objects.isNull(ApplicationContextProvider.getApplicationContext())) {
            ApplicationContext context = (ApplicationContext)Mockito.mock(ApplicationContext.class);
            JpaTransactionManager tm = (JpaTransactionManager)Mockito.mock(JpaTransactionManager.class);
            Mockito.when((Object)((JpaTransactionManager)context.getBean((Class)ArgumentMatchers.eq(JpaTransactionManager.class)))).thenReturn((Object)tm);
            Mockito.when((Object)tm.getEntityManagerFactory()).thenReturn((Object)((EntityManagerFactory)Mockito.mock(EntityManagerFactory.class)));
            TransactionTemplate template = (TransactionTemplate)Mockito.mock(TransactionTemplate.class);
            Mockito.when((Object)((TransactionTemplate)context.getBean((Class)ArgumentMatchers.eq(TransactionTemplate.class)))).thenReturn((Object)template);
            Mockito.when((Object)template.execute((TransactionCallback)ArgumentMatchers.any())).then(m -> ((TransactionCallback)m.getArgument(0)).doInTransaction(null));
            ApplicationContextProvider.setAppContext((ApplicationContext)context);
        }
    }

    public static void mockEntityManager() {
        MockEntityManager entityManager = new MockEntityManager();
        BasePersistenceOperations.setEntityManagerProvider(factory -> entityManager);
    }

    public static void mockAsyncExecutor() {
        Reflection.instantiate(AsyncEntityModifier.class);
        CodeFactory.forceRegisterType(AsyncExecutor.class, (ObjectFactory)CodeFactory.singleton((Object)CodeExecutor.syncExecutor()), null);
    }

    public static void mockContextAndEntityManager() {
        CodeGenMock.mockContext();
        CodeGenMock.mockEntityManager();
    }

    public static void mockQueryProcessor(BiFunction<String, List<Object>, Object> func) {
        QueryProcessor.setProcessor((executor, manager, query, params, resultType, resultClass, mapClass, isNative, isModifying, pagable, flush, lock, hints, filters) -> func.apply(query, params));
    }

    public static void mockJustQuery(Printable query, Object returnObject) {
        CodeGenMock.mockQuery(query.print(), null, returnObject);
    }

    public static void mockJustQuery(Printable query, Supplier<Object> returnObject) {
        CodeGenMock.mockQuery(query.print(), null, returnObject);
    }

    public static void mockQuery(Printable query, List<Object> params, Object returnObject) {
        CodeGenMock.mockQuery(query.print(), params, returnObject);
    }

    public static void mockQuery(Printable query, List<Object> params, Supplier<Object> returnObject) {
        CodeGenMock.mockQuery(query.print(), params, returnObject);
    }

    public static void mockQuery(Queryable query, Object returnObject) {
        CodeGenMock.mockQuery(query.print(), (List<Object>)((QueryAccessor)query).getParams(), returnObject);
    }

    public static void mockQuery(Queryable query, Supplier<Object> returnObject) {
        CodeGenMock.mockQuery(query.print(), (List<Object>)((QueryAccessor)query).getParams(), returnObject);
    }

    public static void mockCountQuery(Queryable query, Long count) {
        CodeGenMock.mockCountQuery(query, () -> count);
    }

    public static void mockCountQuery(Queryable query, Supplier<Long> count) {
        Object q = query.print();
        q = ((String)q).startsWith("select u ") ? ((String)q).replace("select u ", "select count(*) ") : "select count(*) " + (String)q;
        CodeGenMock.mockQuery((String)q, (List<Object>)((QueryAccessor)query).getParams(), count);
    }

    public static void mockExistsQuery(Queryable query, boolean exists) {
        CodeGenMock.mockCountQuery(query, exists ? 1L : 0L);
    }

    public static void mockExistsQuery(Queryable query, Supplier<Boolean> exists) {
        Supplier<Long> result = () -> (Boolean)exists.get() != false ? 1L : 0L;
        CodeGenMock.mockCountQuery(query, result);
    }

    public static void mockQuery(String query, Object returnObject) {
        CodeGenMock.mockQuery(query, null, returnObject);
    }

    public static void mockQuery(String query, List<Object> params, Object returnObject) {
        List<Pair<List<Object>, Object>> mocks;
        if (Objects.isNull(mockedProcessor) || !mockedProcessor.equals(QueryProcessor.getProcessor())) {
            QueryProcessor.setProcessor((QueryProcessor.Processor)CodeGenMock.createMockedProcessor());
        }
        if (Objects.nonNull(mocks = mockedResponses.get(query))) {
            Optional<Pair<List<Object>, Object>> mock = CodeGenMock.findMock(query, params);
            if (mock.isEmpty()) {
                mocks.add((Pair<List<Object>, Object>)Pair.of(params, (Object)returnObject));
            } else if (Objects.nonNull(mock.get().getLeft()) && !(mock.get().getRight() instanceof Supplier)) {
                CodeGenMock.logWarning(query, params);
            }
        } else {
            mockedResponses.put(query, new ArrayList<Pair>(Collections.singletonList(Pair.of(params, (Object)returnObject))));
        }
    }

    public static void mockQueryClear() {
        mockedResponses.clear();
    }

    private static QueryProcessor.Processor createMockedProcessor() {
        mockedProcessor = (executor, manager, query, params, resultType, resultClass, mapClass, isNative, isModifying, pagable, flush, lock, hints, filters) -> {
            PageImpl value;
            Optional<Pair<List<Object>, Object>> mock = CodeGenMock.findMock(query, params);
            if (mock.isEmpty()) {
                CodeGenMock.logError(query, params);
            }
            if ((value = mock.get().getRight()) instanceof Supplier) {
                value = ((Supplier)value).get();
            }
            switch (resultType) {
                case SINGLE: 
                case TUPLE: {
                    return Optional.ofNullable(value);
                }
                case COUNT: 
                case REMOVE: 
                case EXECUTE: {
                    return value;
                }
                case LIST: 
                case TUPLES: {
                    return value instanceof List ? value : List.of(value);
                }
                case PAGE: {
                    return value instanceof Page ? value : new PageImpl(value instanceof List ? (List<PageImpl>)value : List.of(value), pagable, Integer.MAX_VALUE);
                }
            }
            throw new GenericCodeGenException("Unknown query return type!");
        };
        return mockedProcessor;
    }

    private static Optional<Pair<List<Object>, Object>> findMock(String query, List<Object> params) {
        List<Pair<List<Object>, Object>> mocks = mockedResponses.get(query);
        if (Objects.isNull(mocks)) {
            return Optional.empty();
        }
        Optional<Pair<List<Object>, Object>> mock = mocks.stream().filter(p -> CodeGenMock.paramsEquals((Pair<List<Object>, Object>)p, params)).findFirst();
        if (mock.isEmpty()) {
            mock = mocks.stream().filter(p -> Objects.isNull(p.getLeft())).findFirst();
        }
        return mock;
    }

    private static boolean paramsEquals(Pair<List<Object>, Object> pair, List<Object> params) {
        List mockParams = (List)pair.getLeft();
        if (Objects.nonNull(mockParams) && mockParams.size() == params.size()) {
            for (int i = 0; i < params.size(); ++i) {
                if ((!Objects.isNull(mockParams.get(i)) || !Objects.nonNull(params.get(i))) && (mockParams.get(i).equals(params.get(i)) || CodeGenMatcher.class.equals(mockParams.get(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void logError(String query, List<Object> params) {
        throw new QueryNotMockedException(CodeGenMock.logText(query, params) + " is not mocked!");
    }

    private static void logWarning(String query, List<Object> params) {
        log.warn("{} already mocked!", (Object)CodeGenMock.logText(query, params));
    }

    private static String logText(String query, List<Object> params) {
        return "Query '" + query + "' with params [" + params.stream().map(Object::toString).map(s -> "(" + s + ")").collect(Collectors.joining(", ")) + "]";
    }

    public static void mockCreate(Class<?> cls) {
        Reflection.instantiate(cls);
        CodeGenMock.findMocks(cls);
    }

    private static void findMocks(Class<?> cls) {
        CodeGenMock.findMock(cls);
        for (Class<?> i : cls.getInterfaces()) {
            CodeGenMock.findMocks(i);
        }
        for (Class<?> c : cls.getClasses()) {
            CodeGenMock.findMocks(c);
        }
    }

    private static void findMock(Class<?> i) {
        Function<Object, Object> mock = v -> {
            if (CodeGenMatcher.anyMock.get().booleanValue()) {
                CodeGenMatcher.anyMock.set(false);
                v = CodeGenMatcher.class;
            }
            return v;
        };
        Function<Object, Object> onValue = v -> {
            if (Objects.isNull(v) && CodeGenMatcher.anyMock.get().booleanValue()) {
                v = CodeGenMatcher.class;
                CodeGenMatcher.anyMock.set(false);
            }
            return v;
        };
        Class factory = CodeFactory.lookup(i);
        if (Objects.nonNull(factory)) {
            CodeFactory.envelopType(i, f -> {
                Object result = f.create();
                if (result instanceof MockedQuery) {
                    ((MockedQuery)result).setMocked(mock, onValue);
                }
                return result;
            }, (f, p, v) -> {
                Object result = f.create(p, v);
                if (result instanceof MockedQuery) {
                    ((MockedQuery)result).setMocked(mock, onValue);
                }
                return result;
            });
        }
    }

    static {
        mockedResponses = new HashMap<String, List<Pair<List<Object>, Object>>>();
    }
}

