/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.ability;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.ability.AbilityProvider;
import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum Abilities implements Ability
{
    BOUNTIFUL_HARVEST("farming"),
    FARMER("farming"),
    SCYTHE_MASTER("farming"),
    GENETICIST("farming"),
    GROWTH_AURA("farming"),
    LUMBERJACK("foraging"),
    FORAGER("foraging"),
    AXE_MASTER("foraging"),
    VALOR("foraging"),
    SHREDDER("foraging"),
    LUCKY_MINER("mining"),
    MINER("mining"),
    PICK_MASTER("mining"),
    STAMINA("mining"),
    HARDENED_ARMOR("mining"),
    LUCKY_CATCH("fishing"),
    FISHER("fishing"),
    TREASURE_HUNTER("fishing"),
    GRAPPLER("fishing"),
    EPIC_CATCH("fishing"),
    METAL_DETECTOR("excavation"),
    EXCAVATOR("excavation"),
    SPADE_MASTER("excavation"),
    BIGGER_SCOOP("excavation"),
    LUCKY_SPADES("excavation"),
    RETRIEVAL("archery"),
    ARCHER("archery"),
    BOW_MASTER("archery"),
    PIERCING("archery"),
    STUN("archery"),
    SHIELDING("defense"),
    DEFENDER("defense"),
    MOB_MASTER("defense"),
    IMMUNITY("defense"),
    NO_DEBUFF("defense"),
    PARRY("fighting"),
    FIGHTER("fighting"),
    SWORD_MASTER("fighting"),
    FIRST_STRIKE("fighting"),
    BLEED("fighting", true),
    ANTI_HUNGER("endurance"),
    RUNNER("endurance"),
    GOLDEN_HEAL("endurance"),
    RECOVERY("endurance"),
    MEAL_STEAL("endurance"),
    LIGHT_FALL("agility"),
    JUMPER("agility"),
    SUGAR_RUSH("agility"),
    FLEETING("agility"),
    THUNDER_FALL("agility", true),
    ALCHEMIST("alchemy"),
    BREWER("alchemy"),
    SPLASHER("alchemy"),
    LINGERING("alchemy", true),
    WISE_EFFECT("alchemy"),
    XP_CONVERT("enchanting"),
    ENCHANTER("enchanting"),
    XP_WARRIOR("enchanting"),
    ENCHANTED_STRENGTH("enchanting"),
    LUCKY_TABLE("enchanting"),
    SORCERER("sorcery"),
    LIFE_ESSENCE("healing"),
    HEALER("healing"),
    LIFE_STEAL("healing"),
    GOLDEN_HEART("healing"),
    REVIVAL("healing", true),
    DISENCHANTER("forging"),
    FORGER("forging"),
    REPAIRING("forging"),
    ANVIL_MASTER("forging"),
    SKILL_MENDER("forging");

    @Inject
    private AbilityProvider provider;
    private final NamespacedId id = NamespacedId.of("auraskills", this.name().toLowerCase(Locale.ROOT));
    private final boolean hasSecondaryValue;
    private final String legacySkillName;

    private Abilities(String legacySkillName) {
        this(legacySkillName, false);
    }

    private Abilities(String legacySkillName, boolean hasSecondaryValue) {
        this.hasSecondaryValue = hasSecondaryValue;
        this.legacySkillName = legacySkillName;
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public Skill getSkill() {
        return this.provider.getSkill(this);
    }

    public String getLegacySkillName() {
        return this.legacySkillName;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.provider.getDisplayName(this, locale, true);
    }

    @Override
    public String getDisplayName(Locale locale, boolean formatted) {
        return this.provider.getDisplayName(this, locale, formatted);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.provider.getDescription(this, locale, true);
    }

    @Override
    public String getDescription(Locale locale, boolean formatted) {
        return this.provider.getDescription(this, locale, formatted);
    }

    @Override
    public String getInfo(Locale locale) {
        return this.provider.getInfo(this, locale, true);
    }

    @Override
    public String getInfo(Locale locale, boolean formatted) {
        return this.provider.getInfo(this, locale, formatted);
    }

    @Override
    public boolean hasSecondaryValue() {
        return this.hasSecondaryValue;
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public double getBaseValue() {
        return this.provider.getBaseValue(this);
    }

    @Override
    public double getSecondaryBaseValue() {
        return this.provider.getSecondaryBaseValue(this);
    }

    @Override
    public double getValue(int level) {
        return this.provider.getValue(this, level);
    }

    @Override
    public double getValuePerLevel() {
        return this.provider.getValuePerLevel(this);
    }

    @Override
    public double getSecondaryValuePerLevel() {
        return this.provider.getSecondaryValuePerLevel(this);
    }

    @Override
    public double getSecondaryValue(int level) {
        return this.provider.getSecondaryValue(this, level);
    }

    @Override
    public int getUnlock() {
        return this.provider.getUnlock(this);
    }

    @Override
    public int getLevelUp() {
        return this.provider.getLevelUp(this);
    }

    @Override
    public int getMaxLevel() {
        return this.provider.getMaxLevel(this);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }
}

