/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.mana;

import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.mana.ManaAbilityProvider;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum ManaAbilities implements ManaAbility
{
    REPLENISH,
    TREECAPITATOR,
    SPEED_MINE,
    SHARP_HOOK,
    TERRAFORM,
    CHARGED_SHOT,
    ABSORPTION,
    LIGHTNING_BLADE;

    @Inject
    private ManaAbilityProvider provider;
    private final NamespacedId id = NamespacedId.of("auraskills", this.name().toLowerCase(Locale.ROOT));

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public Skill getSkill() {
        return this.provider.getSkill(this);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.provider.getDisplayName(this, locale);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.provider.getDescription(this, locale);
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public double getBaseValue() {
        return this.provider.getBaseValue(this);
    }

    @Override
    public double getValuePerLevel() {
        return this.provider.getValuePerLevel(this);
    }

    @Override
    public double getValue(int level) {
        return this.provider.getValue(this, level);
    }

    @Override
    public double getDisplayValue(int level) {
        return this.provider.getDisplayValue(this, level);
    }

    @Override
    public double getBaseCooldown() {
        return this.provider.getBaseCooldown(this);
    }

    @Override
    public double getCooldownPerLevel() {
        return this.provider.getCooldownPerLevel(this);
    }

    @Override
    public double getCooldown(int level) {
        return this.provider.getCooldown(this, level);
    }

    @Override
    public double getBaseManaCost() {
        return this.provider.getBaseManaCost(this);
    }

    @Override
    public double getManaCostPerLevel() {
        return this.provider.getManaCostPerLevel(this);
    }

    @Override
    public double getManaCost(int level) {
        return this.provider.getManaCost(this, level);
    }

    @Override
    public int getUnlock() {
        return this.provider.getUnlock(this);
    }

    @Override
    public int getLevelUp() {
        return this.provider.getLevelUp(this);
    }

    @Override
    public int getMaxLevel() {
        return this.provider.getMaxLevel(this);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }
}

