/*
 * Decompiled with CFR 0.152.
 */
package dev.arunkumar.scabbard.plugin.processor.graphviz;

import com.google.common.graph.ImmutableNetwork;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.ComponentPath;
import dev.arunkumar.dot.DotGraph;
import dev.arunkumar.scabbard.plugin.di.VisitGraphScope;
import dev.arunkumar.scabbard.plugin.options.ScabbardOptions;
import dev.arunkumar.scabbard.plugin.output.OutputWriter;
import dev.arunkumar.scabbard.plugin.parser.BindingGraphKt;
import dev.arunkumar.scabbard.plugin.processor.BindingGraphProcessor;
import dev.arunkumar.scabbard.plugin.processor.graphviz.renderer.DaggerComponent;
import dev.arunkumar.scabbard.plugin.processor.graphviz.renderer.InheritedBinding;
import dev.arunkumar.scabbard.plugin.processor.graphviz.renderer.RenderingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@VisitGraphScope
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B8\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0011\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/arunkumar/scabbard/plugin/processor/graphviz/ComponentVisualizationProcessor;", "Ldev/arunkumar/scabbard/plugin/processor/BindingGraphProcessor;", "bindingGraph", "Ldagger/model/BindingGraph;", "scabbardOptions", "Ldev/arunkumar/scabbard/plugin/options/ScabbardOptions;", "outputWriters", "", "Ldev/arunkumar/scabbard/plugin/output/OutputWriter;", "Lkotlin/jvm/JvmSuppressWildcards;", "renderingContextProvider", "Ljavax/inject/Provider;", "Ldev/arunkumar/scabbard/plugin/processor/graphviz/renderer/RenderingContext;", "(Ldagger/model/BindingGraph;Ldev/arunkumar/scabbard/plugin/options/ScabbardOptions;Ljava/util/Set;Ljavax/inject/Provider;)V", "getBindingGraph", "()Ldagger/model/BindingGraph;", "inheritedBindings", "", "Ldev/arunkumar/scabbard/plugin/processor/graphviz/renderer/InheritedBinding;", "componentPath", "Ldagger/model/ComponentPath;", "currentBindings", "Ldagger/model/BindingGraph$MaybeBinding;", "process", "", "writeOutput", "currentComponent", "Ljavax/lang/model/element/TypeElement;", "dotGraph", "Ldev/arunkumar/dot/DotGraph;", "scabbard-processor"})
public final class ComponentVisualizationProcessor
implements BindingGraphProcessor {
    @NotNull
    private final BindingGraph bindingGraph;
    @NotNull
    private final ScabbardOptions scabbardOptions;
    @NotNull
    private final Set<OutputWriter> outputWriters;
    @NotNull
    private final Provider<RenderingContext> renderingContextProvider;

    @Inject
    public ComponentVisualizationProcessor(@NotNull BindingGraph bindingGraph, @NotNull ScabbardOptions scabbardOptions, @NotNull Set<OutputWriter> outputWriters, @NotNull Provider<RenderingContext> renderingContextProvider) {
        Intrinsics.checkNotNullParameter((Object)bindingGraph, (String)"bindingGraph");
        Intrinsics.checkNotNullParameter((Object)scabbardOptions, (String)"scabbardOptions");
        Intrinsics.checkNotNullParameter(outputWriters, (String)"outputWriters");
        Intrinsics.checkNotNullParameter(renderingContextProvider, (String)"renderingContextProvider");
        this.bindingGraph = bindingGraph;
        this.scabbardOptions = scabbardOptions;
        this.outputWriters = outputWriters;
        this.renderingContextProvider = renderingContextProvider;
    }

    @Override
    @NotNull
    public BindingGraph getBindingGraph() {
        return this.bindingGraph;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process() {
        block11: {
            ScabbardOptions scabbardOptions$iv = this.scabbardOptions;
            boolean $i$f$processingBlock = false;
            ScabbardOptions $this$exceptionHandler$iv$iv = scabbardOptions$iv;
            boolean $i$f$exceptionHandler = false;
            try {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object value$iv$iv$iv232;
                Object key$iv$iv;
                void $this$groupByTo$iv$iv;
                Map $this$groupBy$iv;
                boolean bl = false;
                ImmutableNetwork network = this.getBindingGraph().network();
                Iterable iterable = network.nodes();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"network.nodes()");
                iterable = iterable;
                boolean $i$f$groupBy = false;
                Iterator iterator = $this$groupBy$iv;
                Object destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    BindingGraph.Node p0 = (BindingGraph.Node)element$iv$iv;
                    boolean bl2 = false;
                    key$iv$iv = p0.componentPath();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    value$iv$iv$iv232 = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv232 == null) {
                        boolean bl3 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv232;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$map = false;
                $this$groupByTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv;
                boolean element$iv$iv = false;
                for (Map.Entry entry : iterator2.entrySet()) {
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$filterNotTo$iv$iv;
                    void $this$filterNot$iv;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Object $this$filterIsInstanceTo$iv$iv;
                    void $dstr$componentPath$nodes;
                    key$iv$iv = entry;
                    Object object = destination$iv$iv;
                    boolean bl4 = false;
                    void $i$f$getOrPut = $dstr$componentPath$nodes;
                    boolean value$iv$iv$iv232 = false;
                    ComponentPath componentPath = (ComponentPath)$i$f$getOrPut.getKey();
                    value$iv$iv$iv232 = $dstr$componentPath$nodes;
                    boolean bl5 = false;
                    List nodes = (List)value$iv$iv$iv232.getValue();
                    RenderingContext renderingContext = (RenderingContext)this.renderingContextProvider.get();
                    TypeElement currentComponent = componentPath.currentComponent();
                    BindingGraph bindingGraph = this.getBindingGraph();
                    Intrinsics.checkNotNullExpressionValue((Object)currentComponent, (String)"currentComponent");
                    List<BindingGraph.ComponentNode> subcomponents = BindingGraphKt.subcomponentsOf(bindingGraph, currentComponent);
                    Iterable $this$filterIsInstance$iv = nodes;
                    boolean $i$f$filterIsInstance232 = false;
                    Iterable iterable2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo232 = false;
                    Iterator iterator3 = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv$iv2 = iterator3.next();
                        if (!(element$iv$iv2 instanceof BindingGraph.MaybeBinding)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    List bindings = (List)destination$iv$iv2;
                    Iterable $i$f$filterIsInstance232 = bindings;
                    Intrinsics.checkNotNullExpressionValue((Object)renderingContext, (String)"renderingContext");
                    $this$filterIsInstanceTo$iv$iv = renderingContext;
                    boolean $i$f$filter232 = false;
                    void $i$f$filterIsInstanceTo232 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        BindingGraph.MaybeBinding p0 = (BindingGraph.MaybeBinding)element$iv$iv3;
                        boolean bl6 = false;
                        if (!$this$filterIsInstanceTo$iv$iv.isEntryPoint(p0)) continue;
                        destination$iv$iv3.add(element$iv$iv3);
                    }
                    List entryPoints = (List)destination$iv$iv3;
                    $this$filterIsInstanceTo$iv$iv = bindings;
                    RenderingContext $i$f$filter232 = renderingContext;
                    boolean $i$f$filterNot = false;
                    destination$iv$iv3 = $this$filterNot$iv;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv4 : $this$filterNotTo$iv$iv) {
                        BindingGraph.MaybeBinding p0 = (BindingGraph.MaybeBinding)element$iv$iv4;
                        boolean bl7 = false;
                        if ($i$f$filter232.isEntryPoint(p0)) continue;
                        destination$iv$iv4.add(element$iv$iv4);
                    }
                    List dependencyBindings = (List)destination$iv$iv4;
                    Iterable $this$flatMap$iv = nodes;
                    boolean $i$f$flatMap = false;
                    $this$filterNotTo$iv$iv = $this$flatMap$iv;
                    Collection destination$iv$iv5 = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                        BindingGraph.Node it = (BindingGraph.Node)element$iv$iv2;
                        boolean bl8 = false;
                        Set set = network.incidentEdges((Object)it);
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"network.incidentEdges(it)");
                        Iterable list$iv$iv = set;
                        CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
                    }
                    List edges = CollectionsKt.distinct((Iterable)((List)destination$iv$iv5));
                    Intrinsics.checkNotNullExpressionValue((Object)componentPath, (String)"componentPath");
                    List inheritedBindings = this.inheritedBindings(componentPath, bindings);
                    DotGraph dotGraphBuilder = renderingContext.createRootDotGraphBuilder-Ds5WxI8(componentPath);
                    new DaggerComponent.GraphRenderer(renderingContext).render-2fQOZSk(dotGraphBuilder, (Object)new DaggerComponent(componentPath, entryPoints, dependencyBindings, subcomponents, inheritedBindings, edges));
                    Pair pair = TuplesKt.to((Object)currentComponent, (Object)dotGraphBuilder);
                    object.add(pair);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair $dstr$currentComponent$dotGraph = (Pair)element$iv;
                    boolean bl9 = false;
                    TypeElement currentComponent = (TypeElement)$dstr$currentComponent$dotGraph.component1();
                    DotGraph dotGraph = (DotGraph)$dstr$currentComponent$dotGraph.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)currentComponent, (String)"currentComponent");
                    this.writeOutput(currentComponent, dotGraph);
                }
            }
            catch (Exception e$iv$iv) {
                ScabbardOptions $this$handleException$iv$iv$iv = $this$exceptionHandler$iv$iv;
                boolean $i$f$handleException = false;
                if (!$this$handleException$iv$iv$iv.getFailOnError()) break block11;
                throw new RuntimeException("Scabbard processor failed", e$iv$iv);
            }
        }
    }

    private final void writeOutput(TypeElement currentComponent, DotGraph dotGraph) {
        String dotString = dotGraph.toString();
        Iterable $this$forEach$iv = this.outputWriters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OutputWriter writer = (OutputWriter)element$iv;
            boolean bl = false;
            OutputWriter.DefaultImpls.write$default(writer, dotString, currentComponent, this.getBindingGraph().isFullBindingGraph(), false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<InheritedBinding> inheritedBindings(ComponentPath componentPath, List<? extends BindingGraph.MaybeBinding> currentBindings) {
        List list;
        if (!componentPath.atRoot()) {
            void $this$mapTo$iv$iv;
            Object $this$groupByTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = currentBindings;
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Binding)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            BindingGraph $i$f$filterIsInstance22 = this.getBindingGraph();
            boolean $i$f$flatMap22 = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Binding p0 = (Binding)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = (Iterable)$i$f$filterIsInstance22.requestedBindings(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv2;
            boolean $i$f$groupBy = false;
            Iterable $i$f$flatMap22 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv;
                element$iv$iv = iterator.next();
                Binding p0 = (Binding)element$iv$iv;
                boolean bl = false;
                ComponentPath key$iv$iv = p0.componentPath();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator2 = iterator.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry key$iv$iv = item$iv$iv = iterator2.next();
                Object object = destination$iv$iv;
                boolean bl3 = false;
                Object t = this.getBindingGraph().componentNode((ComponentPath)it.getKey()).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"bindingGraph.componentNode(it.key).get()");
                InheritedBinding inheritedBinding = new InheritedBinding((BindingGraph.ComponentNode)t, (List)it.getValue());
                object.add(inheritedBinding);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

