/*
 * Decompiled with CFR 0.152.
 */
package dev.arunkumar.scabbard.plugin.processor.graphviz;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import dagger.model.BindingGraph;
import dagger.model.ComponentPath;
import dev.arunkumar.dot.DotGraph;
import dev.arunkumar.dot.DotStatement;
import dev.arunkumar.dot.DotStatementKt;
import dev.arunkumar.dot.Indented;
import dev.arunkumar.dot.dsl.DotGraphBuilder;
import dev.arunkumar.scabbard.plugin.di.VisitGraphScope;
import dev.arunkumar.scabbard.plugin.options.ScabbardOptions;
import dev.arunkumar.scabbard.plugin.output.OutputWriter;
import dev.arunkumar.scabbard.plugin.parser.TypeNameExtractor;
import dev.arunkumar.scabbard.plugin.processor.BindingGraphProcessor;
import dev.arunkumar.scabbard.plugin.processor.graphviz.renderer.ComponentTreeRenderer;
import dev.arunkumar.scabbard.plugin.processor.graphviz.renderer.RenderingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@VisitGraphScope
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B:\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0011\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/arunkumar/scabbard/plugin/processor/graphviz/ComponentTreeVisualizationProcessor;", "Ldev/arunkumar/scabbard/plugin/processor/BindingGraphProcessor;", "bindingGraph", "Ldagger/model/BindingGraph;", "scabbardOptions", "Ldev/arunkumar/scabbard/plugin/options/ScabbardOptions;", "outputWriters", "", "Ldev/arunkumar/scabbard/plugin/output/OutputWriter;", "Lkotlin/jvm/JvmSuppressWildcards;", "renderingContext", "Ldev/arunkumar/scabbard/plugin/processor/graphviz/renderer/RenderingContext;", "typeNameExtractor", "Ldev/arunkumar/scabbard/plugin/parser/TypeNameExtractor;", "(Ldagger/model/BindingGraph;Ldev/arunkumar/scabbard/plugin/options/ScabbardOptions;Ljava/util/Set;Ldev/arunkumar/scabbard/plugin/processor/graphviz/renderer/RenderingContext;Ldev/arunkumar/scabbard/plugin/parser/TypeNameExtractor;)V", "getBindingGraph", "()Ldagger/model/BindingGraph;", "constructComponentTree", "Lcom/google/common/graph/Graph;", "Ldagger/model/BindingGraph$ComponentNode;", "process", "", "writeOutput", "currentComponent", "Ljavax/lang/model/element/TypeElement;", "dotGraph", "Ldev/arunkumar/dot/DotGraph;", "scabbard-processor"})
public final class ComponentTreeVisualizationProcessor
implements BindingGraphProcessor {
    @NotNull
    private final BindingGraph bindingGraph;
    @NotNull
    private final ScabbardOptions scabbardOptions;
    @NotNull
    private final Set<OutputWriter> outputWriters;
    @NotNull
    private final RenderingContext renderingContext;
    @NotNull
    private final TypeNameExtractor typeNameExtractor;

    @Inject
    public ComponentTreeVisualizationProcessor(@NotNull BindingGraph bindingGraph, @NotNull ScabbardOptions scabbardOptions, @NotNull Set<OutputWriter> outputWriters, @NotNull RenderingContext renderingContext, @NotNull TypeNameExtractor typeNameExtractor) {
        Intrinsics.checkNotNullParameter((Object)bindingGraph, (String)"bindingGraph");
        Intrinsics.checkNotNullParameter((Object)scabbardOptions, (String)"scabbardOptions");
        Intrinsics.checkNotNullParameter(outputWriters, (String)"outputWriters");
        Intrinsics.checkNotNullParameter((Object)renderingContext, (String)"renderingContext");
        Intrinsics.checkNotNullParameter((Object)typeNameExtractor, (String)"typeNameExtractor");
        this.bindingGraph = bindingGraph;
        this.scabbardOptions = scabbardOptions;
        this.outputWriters = outputWriters;
        this.renderingContext = renderingContext;
        this.typeNameExtractor = typeNameExtractor;
    }

    @Override
    @NotNull
    public BindingGraph getBindingGraph() {
        return this.bindingGraph;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalStdlibApi
    public void process() {
        block3: {
            ScabbardOptions scabbardOptions$iv = this.scabbardOptions;
            boolean $i$f$processingBlock = false;
            ScabbardOptions $this$exceptionHandler$iv$iv = scabbardOptions$iv;
            boolean $i$f$exceptionHandler = false;
            try {
                boolean bl = false;
                if (!this.getBindingGraph().isFullBindingGraph()) {
                    void $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1;
                    DotStatement $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0;
                    BindingGraph.ComponentNode rootComponentNode = this.getBindingGraph().rootComponentNode();
                    TypeElement rootComponentType = rootComponentNode.componentPath().currentComponent();
                    Graph componentTree = this.constructComponentTree();
                    String string = rootComponentNode.componentPath().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rootComponentNode.componentPath().toString()");
                    String label$iv = string;
                    boolean $i$f$directedGraph = false;
                    DotGraph dotGraph = DotGraphBuilder.constructor-impl((DotGraph)new DotGraph(Intrinsics.stringPlus((String)"digraph ", (Object)DotStatementKt.quote((Object)label$iv))));
                    boolean bl2 = false;
                    boolean bl3 = false;
                    DotGraph $this$process_u24lambda_u2d3_u24lambda_u2d2 = dotGraph;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    DotStatement dotStatement = new DotStatement("graph");
                    boolean bl6 = false;
                    boolean bl7 = false;
                    DotStatement dotStatement2 = dotStatement;
                    DotGraph dotGraph2 = $this$process_u24lambda_u2d3_u24lambda_u2d2;
                    boolean bl8 = false;
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.=("rankdir", (Object)"TB");
                    TypeNameExtractor typeNameExtractor = this.typeNameExtractor;
                    ComponentPath componentPath = rootComponentNode.componentPath();
                    Intrinsics.checkNotNullExpressionValue((Object)componentPath, (String)"rootComponentNode.componentPath()");
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.=("label", (Object)typeNameExtractor.extractName(componentPath));
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.=("compound", (Object)true);
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.=("labeljust", (Object)"l");
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.=("pad", (Object)0.2);
                    Unit unit = Unit.INSTANCE;
                    dotGraph2.add((Indented)dotStatement);
                    boolean bl9 = false;
                    dotStatement = new DotStatement("node");
                    bl6 = false;
                    bl7 = false;
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0 = dotStatement;
                    dotGraph2 = $this$process_u24lambda_u2d3_u24lambda_u2d2;
                    boolean bl10 = false;
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.=("shape", (Object)"rectangle");
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.=("style", (Object)"filled");
                    $this$process_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.=("color", (Object)"turquoise");
                    unit = Unit.INSTANCE;
                    dotGraph2.add((Indented)dotStatement);
                    DotGraph dotGraphBuilder = dotGraph;
                    new ComponentTreeRenderer(this.renderingContext).render-2fQOZSk(dotGraphBuilder, componentTree);
                    Intrinsics.checkNotNullExpressionValue((Object)rootComponentType, (String)"rootComponentType");
                    this.writeOutput(rootComponentType, dotGraphBuilder);
                }
            }
            catch (Exception e$iv$iv) {
                ScabbardOptions $this$handleException$iv$iv$iv = $this$exceptionHandler$iv$iv;
                boolean $i$f$handleException = false;
                if (!$this$handleException$iv$iv$iv.getFailOnError()) break block3;
                throw new RuntimeException("Scabbard processor failed", e$iv$iv);
            }
        }
    }

    private final void writeOutput(TypeElement currentComponent, DotGraph dotGraph) {
        Iterable $this$forEach$iv = this.outputWriters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OutputWriter writer = (OutputWriter)element$iv;
            boolean bl = false;
            writer.write(dotGraph.toString(), currentComponent, this.getBindingGraph().isFullBindingGraph(), true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private final Graph<BindingGraph.ComponentNode> constructComponentTree() {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        TypeElement typeElement;
        Object object;
        void $this$associateByTo$iv$iv;
        ImmutableSet componentNodes = this.getBindingGraph().componentNodes();
        BindingGraph.ComponentNode rootComponentNode = this.getBindingGraph().rootComponentNode();
        MutableGraph mutableGraph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(componentNodes.size()).build();
        Intrinsics.checkNotNullExpressionValue((Object)mutableGraph, (String)"directed()\n      .allowsSelfLoops(false)\n      .expectedNodeCount(componentNodes.size)\n      .build()");
        MutableGraph componentTree = mutableGraph;
        Intrinsics.checkNotNullExpressionValue((Object)componentNodes, (String)"componentNodes");
        Iterable $this$associateBy$iv = (Iterable)componentNodes;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            BindingGraph.ComponentNode componentNode = (BindingGraph.ComponentNode)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            typeElement = it.componentPath().currentComponent();
            object.put(typeElement, element$iv$iv);
        }
        Map componentNodeTypeCache = destination$iv$iv;
        $this$associateBy$iv = (Iterable)componentNodes;
        boolean $i$f$map = false;
        void capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (BindingGraph.ComponentNode)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            typeElement = it.componentPath().components();
            object.add(typeElement);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$scan$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            Object item$iv$iv;
            ImmutableList componentHierarchy = (ImmutableList)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)componentHierarchy, (String)"componentHierarchy");
            item$iv$iv = (Iterable)componentHierarchy;
            boolean $i$f$map2 = false;
            void bl2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                TypeElement typeElement2 = (TypeElement)item$iv$iv2;
                Collection collection = destination$iv$iv3;
                boolean bl3 = false;
                BindingGraph.ComponentNode componentNode = (BindingGraph.ComponentNode)MapsKt.getValue((Map)componentNodeTypeCache, (Object)it);
                collection.add(componentNode);
            }
            $this$map$iv2 = (List)destination$iv$iv3;
            boolean $i$f$scan = false;
            void $this$runningFold$iv$iv = $this$scan$iv;
            boolean $i$f$runningFold = false;
            int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv, (int)9);
            if (estimatedSize$iv$iv == 0) {
                CollectionsKt.listOf((Object)rootComponentNode);
                continue;
            }
            ArrayList arrayList = new ArrayList(estimatedSize$iv$iv + 1);
            boolean item$iv$iv2 = false;
            boolean bl4 = false;
            ArrayList $this$apply$iv$iv = arrayList;
            boolean bl5 = false;
            $this$apply$iv$iv.add(rootComponentNode);
            ArrayList result$iv$iv = arrayList;
            BindingGraph.ComponentNode accumulator$iv$iv = rootComponentNode;
            for (Object element$iv$iv : $this$runningFold$iv$iv) {
                void next;
                BindingGraph.ComponentNode componentNode = (BindingGraph.ComponentNode)element$iv$iv;
                BindingGraph.ComponentNode current = accumulator$iv$iv;
                boolean bl6 = false;
                if (!Intrinsics.areEqual((Object)current, (Object)next)) {
                    componentTree.addNode((Object)current);
                    componentTree.addNode((Object)next);
                    componentTree.putEdge((Object)current, (Object)next);
                }
                accumulator$iv$iv = next;
                result$iv$iv.add(accumulator$iv$iv);
            }
        }
        ImmutableGraph immutableGraph = ImmutableGraph.copyOf((Graph)((Graph)componentTree));
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"copyOf(componentTree)");
        return (Graph)immutableGraph;
    }
}

