/*
 * Decompiled with CFR 0.152.
 */
package dev.arunkumar.scabbard.plugin.output;

import dagger.Module;
import dagger.Provides;
import dagger.multibindings.ElementsIntoSet;
import dev.arunkumar.scabbard.plugin.di.ProcessorScope;
import dev.arunkumar.scabbard.plugin.options.ScabbardOptions;
import dev.arunkumar.scabbard.plugin.output.DotWriter;
import dev.arunkumar.scabbard.plugin.output.OutputManager;
import dev.arunkumar.scabbard.plugin.output.OutputWriter;
import dev.arunkumar.scabbard.plugin.output.PngWriter;
import dev.arunkumar.scabbard.plugin.output.SvgWriter;
import java.util.Set;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u0007\u00a8\u0006\u000f"}, d2={"Ldev/arunkumar/scabbard/plugin/output/OutputWriterModule;", "", "()V", "writers", "", "Ldev/arunkumar/scabbard/plugin/output/OutputWriter;", "scabbardOptions", "Ldev/arunkumar/scabbard/plugin/options/ScabbardOptions;", "dotProvider", "Ljavax/inject/Provider;", "Ldev/arunkumar/scabbard/plugin/output/DotWriter;", "pngProvider", "Ldev/arunkumar/scabbard/plugin/output/PngWriter;", "svgProvider", "Ldev/arunkumar/scabbard/plugin/output/SvgWriter;", "scabbard-processor"})
public final class OutputWriterModule {
    @NotNull
    public static final OutputWriterModule INSTANCE = new OutputWriterModule();

    private OutputWriterModule() {
    }

    @ProcessorScope
    @Provides
    @ElementsIntoSet
    @NotNull
    public final Set<OutputWriter> writers(@NotNull ScabbardOptions scabbardOptions, @NotNull Provider<DotWriter> dotProvider, @NotNull Provider<PngWriter> pngProvider, @NotNull Provider<SvgWriter> svgProvider) {
        Intrinsics.checkNotNullParameter((Object)scabbardOptions, (String)"scabbardOptions");
        Intrinsics.checkNotNullParameter(dotProvider, (String)"dotProvider");
        Intrinsics.checkNotNullParameter(pngProvider, (String)"pngProvider");
        Intrinsics.checkNotNullParameter(svgProvider, (String)"svgProvider");
        Object imageWriterProvider = scabbardOptions.getOutputImageFormat() == OutputManager.Format.SVG ? svgProvider : pngProvider;
        Object[] objectArray = new OutputWriter[2];
        Object object = dotProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dotProvider.get()");
        objectArray[0] = (OutputWriter)object;
        object = imageWriterProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"imageWriterProvider.get()");
        objectArray[1] = (OutputWriter)object;
        return SetsKt.linkedSetOf((Object[])objectArray);
    }
}

