/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.pluginstatlib;

import com.google.gson.Gson;
import dev.array21.pluginstatlib.InvalidUuidResponse;
import dev.array21.pluginstatlib.StatPackage;
import java.io.IOException;
import java.util.function.Consumer;
import nl.thedutchmc.httplib.Http;

public class PluginStat {
    private String uuid = null;
    private Consumer<String> setUuidFn = null;
    private Consumer<Object> logErrFn = null;
    private static final String SERVER = "https://plugin-stat.k8s.array21.dev";
    private static final int INTERVAL_MINUTES = 2;
    private static volatile boolean STOPPING = false;

    public void start() {
        assert (this.uuid != null);
        assert (this.setUuidFn != null);
        assert (this.logErrFn != null);
        Runnable r = new Runnable(){
            private final Http HTTP = new Http();
            private final Gson GSON = new Gson();

            @Override
            public void run() {
                block5: while (!STOPPING) {
                    Http.ResponseObject response;
                    StatPackage statPackage = new StatPackage(PluginStat.this.uuid);
                    String statSerialized = this.GSON.toJson((Object)statPackage);
                    try {
                        response = this.HTTP.makeRequest(Http.RequestMethod.POST, PluginStat.SERVER, null, Http.MediaFormat.JSON, statSerialized, null);
                    }
                    catch (IOException e) {
                        PluginStat.this.logErrFn.accept("Failed to send metrics.");
                        this.sleep();
                        continue;
                    }
                    if (response.getResponseCode() != 200) {
                        switch (response.getResponseCode()) {
                            case 409: {
                                InvalidUuidResponse r = (InvalidUuidResponse)this.GSON.fromJson(response.getMessage(), InvalidUuidResponse.class);
                                PluginStat.this.uuid = r.getNewUuid();
                                PluginStat.this.setUuidFn.accept(r.getNewUuid());
                                continue block5;
                            }
                        }
                    }
                    this.sleep();
                }
            }

            private void sleep() {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r, "PluginStatThread");
        t.start();
    }

    public static void disable() {
        STOPPING = false;
    }

    public static class PluginStatBuilder {
        private PluginStat pluginStat;

        public static PluginStatBuilder createDefault() {
            return new PluginStatBuilder();
        }

        public PluginStatBuilder setUuid(String uuid) {
            this.pluginStat.uuid = uuid;
            return this;
        }

        public PluginStatBuilder setSetUuidFn(Consumer<String> fn) {
            this.pluginStat.setUuidFn = fn;
            return this;
        }

        public PluginStatBuilder setLogErrFn(Consumer<Object> fn) {
            this.pluginStat.logErrFn = fn;
            return this;
        }

        public PluginStat builder() {
            assert (this.pluginStat.uuid != null);
            assert (this.pluginStat.setUuidFn != null);
            assert (this.pluginStat.logErrFn != null);
            return this.pluginStat;
        }
    }
}

