/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.offlineplayers;

import dev.array21.bukkitreflectionlib.ReflectionUtil;
import dev.array21.dutchycore.DutchyCore;
import dev.array21.dutchycore.annotations.Nullable;
import dev.array21.dutchycore.annotations.RegisterModule;
import dev.array21.dutchycore.module.PluginModule;
import dev.array21.dutchycore.module.commands.ModuleCommand;
import dev.array21.dutchycore.module.commands.ModuleTabCompleter;
import dev.array21.dutchycore.utils.Utils;
import dev.array21.offlineplayers.commands.TransferCommandExeuctor;
import dev.array21.offlineplayers.listeners.PlayerJoinEventListener;
import dev.array21.offlineplayers.tabcompleters.TransferCommandTabCompleter;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionDefault;

@RegisterModule(name="OfflinePlayers", version="1.2.0", author="Dutchy76", infoUrl="https://github.com/DutchyPlugins/OfflinePlayers")
public class OfflinePlayers
extends PluginModule {
    private HashMap<String, String> pendingTransfers = new HashMap();
    private String levelName;

    public void enable(DutchyCore plugin) {
        super.logInfo((Object)"Initializing...");
        if (Bukkit.getOnlineMode()) {
            super.logWarn((Object)"OfflinePlayers is not ment to be used on servers running in online mode. Aborting initialization.");
            return;
        }
        try {
            Object properties = ReflectionUtil.getObject((Object)Bukkit.getServer(), Bukkit.getServer().getClass(), (String)"getProperties");
            this.levelName = ReflectionUtil.isUseNewSpigotPackaging() ? (String)ReflectionUtil.getObject((Object)properties, (String)"p") : (String)ReflectionUtil.getObject((Object)properties, (String)"levelName");
        }
        catch (Exception e) {
            super.logWarn((Object)"Failed to load. Unable to get levelName.");
            super.logWarn((Object)Utils.getStackTrace((Throwable)e));
        }
        super.registerCommand("transfer", (ModuleCommand)new TransferCommandExeuctor(this), (PluginModule)this);
        super.registerTabCompleter("transfer", (ModuleTabCompleter)new TransferCommandTabCompleter(), (PluginModule)this);
        super.registerPermissionNode("offlineplayers.transfer", PermissionDefault.TRUE, "Allows user-level usage of /transfer", null);
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        children.put("offlineplayers.transfer", true);
        super.registerPermissionNode("offlineplayers.transfer.admin", PermissionDefault.OP, "Allows admin-level usage of /transfer", children);
        super.registerEventListener((Listener)new PlayerJoinEventListener(this));
        super.logInfo((Object)"Initialization complete.");
    }

    @Nullable
    public String getPendingTransferOldUsername(String newUserName) {
        return this.pendingTransfers.get(newUserName);
    }

    public void addNewPendingTransfer(String newUserName, String oldUserName) {
        this.pendingTransfers.put(newUserName, oldUserName);
    }

    public void removePendingTransfer(String newUserName) {
        this.pendingTransfers.remove(newUserName);
    }

    public String getLevelName() {
        return this.levelName;
    }
}

