/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.offlineplayers.listeners;

import dev.array21.dutchycore.Triple;
import dev.array21.dutchycore.utils.Utils;
import dev.array21.offlineplayers.OfflinePlayers;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinEventListener
implements Listener {
    private OfflinePlayers module;

    public PlayerJoinEventListener(OfflinePlayers module) {
        this.module = module;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        String playerName = event.getPlayer().getName();
        String oldUserName = this.module.getPendingTransferOldUsername(playerName);
        if (oldUserName == null) {
            return;
        }
        this.module.removePendingTransfer(playerName);
        String message = "Your account has been successfully transferred from %s to %s! Most of your data is migrated, but not everything might work as you expect. Data from some plugins might not be transfered!";
        message = Utils.processColours((String)(ChatColor.GOLD + message), (Triple[])new Triple[]{new Triple((Object)"%s", (Object)ChatColor.RED, (Object)ChatColor.GOLD)});
        event.getPlayer().sendMessage(String.format(message, oldUserName, playerName));
    }
}

