/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.offlineplayers.commands;

import com.google.common.io.Files;
import dev.array21.dutchycore.Triple;
import dev.array21.dutchycore.module.commands.ModuleCommand;
import dev.array21.dutchycore.utils.Utils;
import dev.array21.offlineplayers.OfflinePlayers;
import dev.array21.offlineplayers.events.PlayerTransferEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TransferCommandExeuctor
implements ModuleCommand {
    private OfflinePlayers module;

    public TransferCommandExeuctor(OfflinePlayers module) {
        this.module = module;
    }

    public boolean fire(CommandSender sender, String[] args) {
        if (!sender.hasPermission("offlineplayers.transfer")) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to use this command!");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage("Not enough arguments provided!");
            return true;
        }
        if (sender.hasPermission("offlineplayers.transfer.admin") && args.length >= 2) {
            UUID transferToUuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + args[1]).getBytes(StandardCharsets.UTF_8));
            if (Bukkit.getPlayer((UUID)transferToUuid) != null && Bukkit.getPlayer((UUID)transferToUuid).isOnline()) {
                sender.sendMessage(ChatColor.RED + "You cannot transfer that account to a player that is online!");
                return true;
            }
            Player toTransfer = Bukkit.getPlayer((String)args[0]);
            if (toTransfer == null) {
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (!offlinePlayer.getName().equals(args[0])) continue;
                    toTransfer = (Player)offlinePlayer;
                }
            }
            if (toTransfer == null) {
                String message = Utils.processColours((String)(ChatColor.GOLD + "Unknown player: %s !"), (Triple[])new Triple[]{new Triple((Object)"%s", (Object)ChatColor.RED, (Object)ChatColor.GOLD)});
                sender.sendMessage(String.format(message, args[0]));
            }
            String newUserName = args[1];
            this.module.addNewPendingTransfer(newUserName, toTransfer.getName());
            if (toTransfer.isOnline()) {
                Object message = ChatColor.GOLD + "Your account has been transferred to %s by an administrator!";
                message = Utils.processColours((String)message, (Triple[])new Triple[]{new Triple((Object)"%s", (Object)ChatColor.RED, (Object)ChatColor.GOLD)});
                toTransfer.kickPlayer(String.format((String)message, newUserName));
            }
            this.transferPlayerDataFile(toTransfer.getName(), newUserName);
            this.module.throwModuleEvent(new PlayerTransferEvent(toTransfer.getName(), newUserName));
            Object message = ChatColor.GOLD + "Registered %s as new username for %s. They should now log in with their new username.";
            message = Utils.processColours((String)message, (Triple[])new Triple[]{new Triple((Object)"%s", (Object)ChatColor.RED, (Object)ChatColor.GOLD)});
            sender.sendMessage(String.format((String)message, newUserName, toTransfer.getName()));
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Invalid usage! /transfer <old username> <new user name>");
                return true;
            }
            UUID transferToUuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + args[0]).getBytes(StandardCharsets.UTF_8));
            if (Bukkit.getPlayer((UUID)transferToUuid) != null && Bukkit.getPlayer((UUID)transferToUuid).isOnline()) {
                sender.sendMessage(ChatColor.RED + "You cannot transfer your account to a player that is online!");
                return true;
            }
            Player player = (Player)sender;
            String newUserName = args[0];
            this.module.addNewPendingTransfer(newUserName, player.getName());
            String message = "Transferring your account to %s!";
            message = Utils.processColours((String)(ChatColor.GOLD + message), (Triple[])new Triple[]{new Triple((Object)"%s", (Object)ChatColor.RED, (Object)ChatColor.GOLD)});
            player.kickPlayer(String.format(message, newUserName));
            this.module.throwModuleEvent(new PlayerTransferEvent(sender.getName(), newUserName));
            this.transferPlayerDataFile(player.getName(), newUserName);
        }
        return true;
    }

    private void transferPlayerDataFile(String currentPlayerName, String newPlayerName) {
        String offlinePlayerCurrentName = UUID.nameUUIDFromBytes(("OfflinePlayer:" + currentPlayerName).getBytes(StandardCharsets.UTF_8)).toString();
        String offlinePlayerNewName = UUID.nameUUIDFromBytes(("OfflinePlayer:" + newPlayerName).getBytes(StandardCharsets.UTF_8)).toString();
        File playerDataFolder = new File(Bukkit.getWorldContainer() + File.separator + this.module.getLevelName() + File.separator + "playerdata");
        File currentPlayerDataFile = new File(playerDataFolder, offlinePlayerCurrentName + ".dat");
        File newPlayerDataFile = new File(playerDataFolder, offlinePlayerNewName + ".dat");
        try {
            Files.move((File)currentPlayerDataFile, (File)newPlayerDataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

