/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.jdbd.util;

import dev.array21.jdbd.exceptions.UnsupportedOperatingSystemException;
import dev.array21.jdbd.util.Pair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.regex.Pattern;

public class LibraryUtils {
    public static String getLibraryPath(String name) throws UnsupportedOperatingSystemException {
        String libName;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux")) {
            libName = String.format("/x86_64/linux/%s.so", name);
        } else if (os.contains("windows")) {
            libName = String.format("/x86_64/windows/%s.dll", name);
        } else {
            throw new UnsupportedOperatingSystemException("Unsupported OS: " + os);
        }
        return libName;
    }

    public static Pair<File, File> saveLibrary(String path) throws IOException {
        String[] nameParts = path.split(Pattern.quote("/"));
        String libName = nameParts[nameParts.length - 1];
        String[] libNameParts = libName.split(Pattern.quote("."));
        String libNameWithoutExtension = String.join((CharSequence)"", Arrays.copyOfRange(libNameParts, 0, libNameParts.length - 1));
        URL url = LibraryUtils.class.getResource(path);
        File tmpDir = Files.createTempDirectory("jdbd" + libNameWithoutExtension, new FileAttribute[0]).toFile();
        tmpDir.deleteOnExit();
        File tmpFile = new File(tmpDir, libName);
        tmpFile.deleteOnExit();
        InputStream is = url.openStream();
        Files.copy(is, tmpFile.toPath(), new CopyOption[0]);
        return new Pair<File, File>(tmpDir, tmpFile);
    }
}

