/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.jdbd.drivers;

import dev.array21.jdbd.DatabaseDriver;
import dev.array21.jdbd.datatypes.PreparedStatement;
import dev.array21.jdbd.datatypes.SqlParameter;
import dev.array21.jdbd.datatypes.SqlRow;
import dev.array21.jdbd.drivers.DriverManager;
import dev.array21.jdbd.exceptions.DriverUnloadedException;
import dev.array21.jdbd.exceptions.SqlException;
import dev.array21.jdbd.exceptions.UnboundPreparedStatementException;
import java.io.IOException;

public class MysqlDriver
implements DatabaseDriver {
    private String errorBuffer;
    private String host;
    private String username;
    private String password;
    private String database;
    private long ptr;
    private volatile boolean ptrValid = false;

    private MysqlDriver() {
    }

    protected MysqlDriver(String host, String username, String password, String database) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.database = database;
    }

    public void loadDriver() throws IOException {
        DriverManager.loadLibrary();
        this.ptr = this.initializeNative();
        if (this.ptr == 0L) {
            throw new RuntimeException("Failed to load driver: " + this.errorBuffer);
        }
        this.ptrValid = true;
    }

    private void checkValid() {
        if (!DriverManager.isLoaded()) {
            throw new IllegalStateException("libjdbd is not loaded");
        }
        if (!this.ptrValid) {
            throw new DriverUnloadedException("Driver has already been unloaded");
        }
    }

    public boolean isLoaded() {
        return DriverManager.isLoaded() && this.ptrValid;
    }

    @Override
    public synchronized SqlRow[] query(PreparedStatement statement) throws SqlException {
        this.checkValid();
        if (!statement.allBound()) {
            throw new UnboundPreparedStatementException("Not all paramaters are bound");
        }
        SqlRow[] resultSet = this.queryNative(this.ptr, statement.getStmt(), statement.getParameters());
        if (resultSet == null) {
            String buffer = this.errorBuffer;
            this.errorBuffer = "";
            throw new SqlException(buffer);
        }
        return resultSet;
    }

    @Override
    public synchronized void execute(PreparedStatement statement) throws SqlException {
        this.checkValid();
        if (!statement.allBound()) {
            throw new UnboundPreparedStatementException("Not all paramaters are bound");
        }
        int status = this.executeNative(this.ptr, statement.getStmt(), statement.getParameters());
        if (status != 0) {
            String buffer = this.errorBuffer;
            this.errorBuffer = "";
            throw new SqlException(buffer);
        }
    }

    @Override
    public synchronized void unload() {
        this.checkValid();
        this.ptrValid = false;
        this.unloadNative(this.ptr);
        this.ptr = 0L;
    }

    private synchronized native long initializeNative();

    private synchronized native int executeNative(long var1, String var3, SqlParameter[] var4);

    private synchronized native SqlRow[] queryNative(long var1, String var3, SqlParameter[] var4);

    private synchronized native void unloadNative(long var1);
}

