/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.espocrm.client;

import com.google.gson.Gson;
import dev.array21.espocrm.Serializer;
import dev.array21.espocrm.client.RequestException;
import dev.array21.espocrm.types.Method;
import dev.array21.espocrm.types.Params;
import dev.array21.httplib.Http;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EspoApiClient {
    protected String url;
    protected String username;
    protected String password;
    protected String apiKey;
    protected String secretKey;
    private final String urlPath = "/api/v1/";
    private final Gson gson = new Gson();

    private String normalizeUrl(String action) {
        return String.format("%s%s%s", this.url, this.urlPath, action);
    }

    public String requestGet(String action, Params params) throws InvalidKeyException, IOException, RequestException {
        return this.request(Method.GET, action, params, null);
    }

    public <T> String request(Method method, String action, T payload) throws InvalidKeyException, IOException, RequestException {
        return this.request(method, action, null, payload);
    }

    private <T> String request(Method method, String action, Params params, T payload) throws InvalidKeyException, IOException, RequestException {
        String url = this.normalizeUrl(action);
        if (params != null && method != Method.POST) {
            url = String.format("%s?%s", url, Serializer.serialize(params));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.username != null && this.password != null) {
            String authString = URLEncoder.encode(String.format("%s:%s", this.username, this.password), StandardCharsets.UTF_8);
            headers.put("Authorization", String.format("Basic %s", Base64.getEncoder().encodeToString(authString.getBytes())));
        } else if (this.apiKey != null && this.secretKey != null) {
            headers.put("X-Hmac-Authorization", this.getHmacAuthorization(method, action));
        } else if (this.apiKey != null && this.secretKey == null) {
            headers.put("X-Api_key", this.apiKey);
        }
        Http.ResponseObject responseObject = payload != null && method != Method.GET ? new Http().makeRequest(this.toRequestMethod(method), url, null, Http.MediaFormat.JSON, this.gson.toJson(payload), headers) : new Http().makeRequest(this.toRequestMethod(method), url, null, null, null, headers);
        if (responseObject.getResponseCode() != 200) {
            throw new RequestException(responseObject.getResponseCode(), responseObject.getConnectionMessage());
        }
        return responseObject.getMessage();
    }

    private String getHmacAuthorization(Method method, String path) throws InvalidKeyException {
        Mac sha256_HMAC = null;
        try {
            sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(this.secretKey.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secretKey);
        }
        catch (NoSuchAlgorithmException secretKey) {
            // empty catch block
        }
        byte[] hash = sha256_HMAC.doFinal((method.toString() + " /" + path).getBytes());
        ArrayList<Byte> hmacBytes = new ArrayList<Byte>();
        hmacBytes.addAll(Arrays.asList(EspoApiClient.toObject((this.apiKey + ":").getBytes())));
        hmacBytes.addAll(Arrays.asList(EspoApiClient.toObject(hash)));
        String hmacAuthorization = Base64.getEncoder().encodeToString(EspoApiClient.toPrimitive(hmacBytes.toArray(new Byte[0])));
        return hmacAuthorization;
    }

    private static Byte[] toObject(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Byte[0];
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    private static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    private Http.RequestMethod toRequestMethod(Method method) {
        switch (method) {
            case GET: {
                return Http.RequestMethod.GET;
            }
            case DELETE: {
                return Http.RequestMethod.DELETE;
            }
            case POST: {
                return Http.RequestMethod.POST;
            }
            case PUT: {
                return Http.RequestMethod.PUT;
            }
        }
        return null;
    }
}

