/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.embedding;

import dev.ai4j.openai4j.Experimental;
import dev.ai4j.openai4j.embedding.Embedding;
import dev.ai4j.openai4j.shared.Usage;
import java.util.Collections;
import java.util.List;

public final class EmbeddingResponse {
    private final String model;
    private final List<Embedding> data;
    private final Usage usage;

    private EmbeddingResponse(Builder builder) {
        this.model = builder.model;
        this.data = builder.data;
        this.usage = builder.usage;
    }

    public String model() {
        return this.model;
    }

    public List<Embedding> data() {
        return this.data;
    }

    public Usage usage() {
        return this.usage;
    }

    @Experimental
    public List<Float> embedding() {
        return this.data.get(0).embedding();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmbeddingResponse && this.equalTo((EmbeddingResponse)another);
    }

    private boolean equalTo(EmbeddingResponse another) {
        return this.model.equals(another.model) && this.data.equals(another.data) && this.usage.equals(another.usage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + this.usage.hashCode();
        return h;
    }

    public String toString() {
        return "EmbeddingResponse{model=" + this.model + ", data=" + this.data + ", usage=" + this.usage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String model;
        private List<Embedding> data;
        private Usage usage;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder data(List<Embedding> data) {
            if (data == null) {
                return this;
            }
            this.data = Collections.unmodifiableList(data);
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public EmbeddingResponse build() {
            return new EmbeddingResponse(this);
        }
    }
}

