/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.embedding;

import dev.ai4j.openai4j.Experimental;
import dev.ai4j.openai4j.Model;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class EmbeddingRequest {
    private final String model;
    private final List<String> input;
    private final String user;

    private EmbeddingRequest(Builder builder) {
        this.model = builder.model;
        this.input = builder.input;
        this.user = builder.user;
    }

    public String model() {
        return this.model;
    }

    public List<String> input() {
        return this.input;
    }

    public String user() {
        return this.user;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmbeddingRequest && this.equalTo((EmbeddingRequest)another);
    }

    private boolean equalTo(EmbeddingRequest another) {
        return this.model.equals(another.model) && this.input.equals(another.input) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "EmbeddingRequest{model=" + this.model + ", input=" + this.input + ", user=" + this.user + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String model = Model.TEXT_EMBEDDING_ADA_002.stringValue();
        private List<String> input;
        private String user;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        @Experimental
        public Builder model(Model model) {
            return this.model(model.stringValue());
        }

        @Experimental
        public Builder input(String ... input) {
            return this.input(Arrays.asList(input));
        }

        public Builder input(List<String> input) {
            if (input == null) {
                return this;
            }
            this.input = Collections.unmodifiableList(input);
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this);
        }
    }
}

