/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.completion;

import dev.ai4j.openai4j.Experimental;
import dev.ai4j.openai4j.Model;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CompletionRequest {
    private final String model;
    private final String prompt;
    private final String suffix;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Integer n;
    private final Boolean stream;
    private final Integer logprobs;
    private final Boolean echo;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final Integer bestOf;
    private final Map<String, Integer> logitBias;
    private final String user;

    private CompletionRequest(Builder builder) {
        this.model = builder.model;
        this.prompt = builder.prompt;
        this.suffix = builder.suffix;
        this.maxTokens = builder.maxTokens;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.n = builder.n;
        this.stream = builder.stream;
        this.logprobs = builder.logprobs;
        this.echo = builder.echo;
        this.stop = builder.stop;
        this.presencePenalty = builder.presencePenalty;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.bestOf = builder.bestOf;
        this.logitBias = builder.logitBias;
        this.user = builder.user;
    }

    public String model() {
        return this.model;
    }

    public String prompt() {
        return this.prompt;
    }

    public String suffix() {
        return this.suffix;
    }

    public Integer maxTokens() {
        return this.maxTokens;
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Integer n() {
        return this.n;
    }

    public Boolean stream() {
        return this.stream;
    }

    public Integer logprobs() {
        return this.logprobs;
    }

    public Boolean echo() {
        return this.echo;
    }

    public List<String> stop() {
        return this.stop;
    }

    public Double presencePenalty() {
        return this.presencePenalty;
    }

    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer bestOf() {
        return this.bestOf;
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public String user() {
        return this.user;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CompletionRequest && this.equalTo((CompletionRequest)another);
    }

    private boolean equalTo(CompletionRequest another) {
        return this.model.equals(another.model) && this.prompt.equals(another.prompt) && this.suffix.equals(another.suffix) && this.maxTokens.equals(another.maxTokens) && this.temperature.equals(another.temperature) && this.topP.equals(another.topP) && this.n.equals(another.n) && this.stream.equals(another.stream) && this.logprobs.equals(another.logprobs) && this.echo.equals(another.echo) && this.stop.equals(another.stop) && this.presencePenalty.equals(another.presencePenalty) && this.frequencyPenalty.equals(another.frequencyPenalty) && this.bestOf.equals(another.bestOf) && this.logitBias.equals(another.logitBias) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.prompt.hashCode();
        h += (h << 5) + this.suffix.hashCode();
        h += (h << 5) + this.maxTokens.hashCode();
        h += (h << 5) + this.temperature.hashCode();
        h += (h << 5) + this.topP.hashCode();
        h += (h << 5) + this.n.hashCode();
        h += (h << 5) + this.stream.hashCode();
        h += (h << 5) + this.logprobs.hashCode();
        h += (h << 5) + this.echo.hashCode();
        h += (h << 5) + this.stop.hashCode();
        h += (h << 5) + this.presencePenalty.hashCode();
        h += (h << 5) + this.frequencyPenalty.hashCode();
        h += (h << 5) + this.bestOf.hashCode();
        h += (h << 5) + this.logitBias.hashCode();
        h += (h << 5) + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "CompletionRequest{model=" + this.model + ", prompt=" + this.prompt + ", suffix=" + this.suffix + ", maxTokens=" + this.maxTokens + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", logprobs=" + this.logprobs + ", echo=" + this.echo + ", stop=" + this.stop + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", bestOf=" + this.bestOf + ", logitBias=" + this.logitBias + ", user=" + this.user + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String model = Model.TEXT_DAVINCI_003.stringValue();
        private String prompt;
        private String suffix;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private Integer logprobs;
        private Boolean echo;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Integer bestOf;
        private Map<String, Integer> logitBias;
        private String user;

        private Builder() {
        }

        @Experimental
        public Builder from(CompletionRequest request) {
            this.model(request.model);
            this.prompt(request.prompt);
            this.suffix(request.suffix);
            this.maxTokens(request.maxTokens);
            this.temperature(request.temperature);
            this.topP(request.topP);
            this.n(request.n);
            this.stream(request.stream);
            this.logprobs(request.logprobs);
            this.echo(request.echo);
            this.stop(request.stop);
            this.presencePenalty(request.presencePenalty);
            this.frequencyPenalty(request.frequencyPenalty);
            this.bestOf(request.bestOf);
            this.logitBias(request.logitBias);
            this.user(request.user);
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        @Experimental
        public Builder model(Model model) {
            return this.model(model.stringValue());
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public Builder stop(List<String> stop) {
            if (stop == null) {
                return this;
            }
            this.stop = Collections.unmodifiableList(stop);
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder bestOf(Integer bestOf) {
            this.bestOf = bestOf;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            if (logitBias == null) {
                return this;
            }
            this.logitBias = Collections.unmodifiableMap(logitBias);
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public CompletionRequest build() {
            return new CompletionRequest(this);
        }
    }
}

