/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ResponseLoggingInterceptor.class);

    ResponseLoggingInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        log.debug("Response code: {}", (Object)response.code());
        log.debug("Response headers: {}", (Object)ResponseLoggingInterceptor.inOneLine(response));
        if (ResponseLoggingInterceptor.isEventStream(response)) {
            log.debug("Response body: [skipping response body due to streaming]");
        } else {
            log.debug("Response body: {}", (Object)response.peekBody(Long.MAX_VALUE).string());
        }
        return response;
    }

    private static boolean isEventStream(Response response) {
        String contentType = response.header("content-type");
        return contentType != null && contentType.contains("event-stream");
    }

    private static String inOneLine(Response response) {
        return Arrays.stream(response.headers().toString().split("\n")).filter(header -> header != null && !header.isEmpty()).map(header -> "[" + header + "]").collect(Collectors.joining(", "));
    }
}

