/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.ai4j.openai4j.ApiKeyInsertingInterceptor;
import dev.ai4j.openai4j.Experimental;
import dev.ai4j.openai4j.Json;
import dev.ai4j.openai4j.OpenAiApi;
import dev.ai4j.openai4j.RequestLoggingInterceptor;
import dev.ai4j.openai4j.ResponseHandler;
import dev.ai4j.openai4j.ResponseLoggingInterceptor;
import dev.ai4j.openai4j.StreamingResponseHandler;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class OpenAiService {
    private static final Logger log = LoggerFactory.getLogger(OpenAiService.class);
    private final String url;
    private final OkHttpClient okHttpClient;
    private final OpenAiApi openAiApi;

    public OpenAiService(String apiKey) {
        this(OpenAiService.builder().apiKey(apiKey));
    }

    private OpenAiService(Builder builder) {
        this.url = builder.url;
        this.okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new ApiKeyInsertingInterceptor(builder.apiKey)).addInterceptor((Interceptor)new RequestLoggingInterceptor()).addInterceptor((Interceptor)new ResponseLoggingInterceptor()).callTimeout(builder.timeout).build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(builder.url).client(this.okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.openAiApi = (OpenAiApi)retrofit.create(OpenAiApi.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletionResponse getCompletions(CompletionRequest request) {
        if (request.stream() != null && request.stream().booleanValue()) {
            throw new IllegalArgumentException("Request parameter 'stream' with value 'true' is not compatible with getCompletion(...) method. If you need streaming, use one of streamCompletion(...) methods. If you do NOT need streaming, do not set 'stream' parameter in CompletionRequest, or set it to 'false'.");
        }
        return this.execute(this.openAiApi.completion(request));
    }

    @Experimental
    public String getCompletion(String prompt) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).build();
        CompletionResponse response = this.getCompletions(request);
        return response.text();
    }

    @Experimental
    public void getCompletionsAsync(CompletionRequest request, final ResponseHandler<CompletionResponse> handler) {
        if (request.stream() != null && request.stream().booleanValue()) {
            throw new IllegalArgumentException("Request parameter 'stream' with value 'true' is not compatible with getCompletionAsync(...) method. If you need streaming, use one of streamCompletion(...) methods. If you do NOT need streaming, do not set 'stream' parameter in CompletionRequest, or set it to 'false'.");
        }
        this.openAiApi.completion(request).enqueue((Callback)new Callback<CompletionResponse>(){

            public void onResponse(Call<CompletionResponse> call, retrofit2.Response<CompletionResponse> response) {
                if (response.isSuccessful()) {
                    handler.onResponse(response.body());
                } else {
                    try {
                        handler.onFailure(new RuntimeException(response.errorBody().string()));
                    }
                    catch (IOException e) {
                        handler.onFailure(e);
                    }
                }
            }

            public void onFailure(Call<CompletionResponse> call, Throwable t) {
                handler.onFailure(t);
            }
        });
    }

    @Experimental
    public void getCompletionAsync(String prompt, final ResponseHandler<String> handler) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).build();
        this.getCompletionsAsync(request, new ResponseHandler<CompletionResponse>(){

            @Override
            public void onResponse(CompletionResponse response) {
                handler.onResponse(response.text());
            }

            @Override
            public void onFailure(Throwable t) {
                handler.onFailure(t);
            }
        });
    }

    @Experimental
    public void streamCompletions(CompletionRequest request, StreamingResponseHandler handler) {
        if (request.stream() != null && !request.stream().booleanValue()) {
            throw new IllegalArgumentException("Request parameter 'stream' with value 'false' is not compatible with streamCompletion(...) method. If you do not need streaming, use one of getCompletion(...) or getCompletionAsync(...) methods. If you need streaming, do not set 'stream' parameter in CompletionRequest, or set it to 'true'.");
        }
        this.stream(CompletionRequest.builder().from(request).stream(true).build(), "v1/completions", CompletionResponse.class, CompletionResponse::text, handler);
    }

    @Experimental
    public void streamCompletion(String prompt, StreamingResponseHandler handler) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).build();
        this.streamCompletions(request, handler);
    }

    public ChatCompletionResponse getChatCompletions(ChatCompletionRequest request) {
        if (request.stream() != null && request.stream().booleanValue()) {
            throw new IllegalArgumentException("Request parameter 'stream' with value 'true' is not compatible with getChatCompletion(...) method. If you need streaming, use one of streamChatCompletion(...) methods. If you do NOT need streaming, do not set 'stream' parameter in ChatCompletionRequest, or set it to 'false'.");
        }
        return this.execute(this.openAiApi.chatCompletion(request));
    }

    @Experimental
    public String getChatCompletion(String userMessage) {
        ChatCompletionRequest request = ChatCompletionRequest.builder().addUserMessage(userMessage).build();
        ChatCompletionResponse response = this.getChatCompletions(request);
        return response.content();
    }

    @Experimental
    public void getChatCompletionsAsync(ChatCompletionRequest request, final ResponseHandler<ChatCompletionResponse> handler) {
        if (request.stream() != null && request.stream().booleanValue()) {
            throw new IllegalArgumentException("Request parameter 'stream' with value 'true' is not compatible with getChatCompletionAsync(...) method. If you need streaming, use one of streamChatCompletion(...) methods. If you do NOT need streaming, do not set 'stream' parameter in ChatCompletionRequest, or set it to 'false'.");
        }
        this.openAiApi.chatCompletion(request).enqueue((Callback)new Callback<ChatCompletionResponse>(){

            public void onResponse(Call<ChatCompletionResponse> call, retrofit2.Response<ChatCompletionResponse> response) {
                if (response.isSuccessful()) {
                    handler.onResponse(response.body());
                } else {
                    try {
                        handler.onFailure(new RuntimeException(response.errorBody().string()));
                    }
                    catch (IOException e) {
                        handler.onFailure(e);
                    }
                }
            }

            public void onFailure(Call<ChatCompletionResponse> call, Throwable t) {
                handler.onFailure(t);
            }
        });
    }

    @Experimental
    public void getChatCompletionAsync(String userMessage, final ResponseHandler<String> handler) {
        ChatCompletionRequest request = ChatCompletionRequest.builder().addUserMessage(userMessage).build();
        this.getChatCompletionsAsync(request, new ResponseHandler<ChatCompletionResponse>(){

            @Override
            public void onResponse(ChatCompletionResponse response) {
                handler.onResponse(response.content());
            }

            @Override
            public void onFailure(Throwable t) {
                handler.onFailure(t);
            }
        });
    }

    @Experimental
    public void streamChatCompletions(ChatCompletionRequest request, StreamingResponseHandler handler) {
        if (request.stream() != null && !request.stream().booleanValue()) {
            throw new IllegalArgumentException("Request parameter 'stream' with value 'false' is not compatible with streamChatCompletion(...) method. If you do not need streaming, use one of getChatCompletion(...) or getChatCompletionAsync(...) methods. If you need streaming, do not set 'stream' parameter in ChatCompletionRequest, or set it to 'true'.");
        }
        this.stream(ChatCompletionRequest.builder().from(request).stream(true).build(), "v1/chat/completions", ChatCompletionResponse.class, response -> response.choices().get(0).delta().content(), handler);
    }

    @Experimental
    public void streamChatCompletion(String userMessage, StreamingResponseHandler handler) {
        ChatCompletionRequest request = ChatCompletionRequest.builder().addUserMessage(userMessage).stream(true).build();
        this.stream(request, "v1/chat/completions", ChatCompletionResponse.class, response -> response.choices().get(0).delta().content(), handler);
    }

    public EmbeddingResponse getEmbeddings(EmbeddingRequest request) {
        return this.execute(this.openAiApi.embedding(request));
    }

    @Experimental
    public List<Float> getEmbedding(String input) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(input).build();
        EmbeddingResponse response = this.getEmbeddings(request);
        return response.embedding();
    }

    @Experimental
    public void getEmbeddingsAsync(EmbeddingRequest request, final ResponseHandler<EmbeddingResponse> handler) {
        this.openAiApi.embedding(request).enqueue((Callback)new Callback<EmbeddingResponse>(){

            public void onResponse(Call<EmbeddingResponse> call, retrofit2.Response<EmbeddingResponse> response) {
                handler.onResponse(response.body());
            }

            public void onFailure(Call<EmbeddingResponse> call, Throwable t) {
                handler.onFailure(t);
            }
        });
    }

    @Experimental
    public void getEmbeddingAsync(String input, final ResponseHandler<List<Float>> handler) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(input).build();
        this.openAiApi.embedding(request).enqueue((Callback)new Callback<EmbeddingResponse>(){

            public void onResponse(Call<EmbeddingResponse> call, retrofit2.Response<EmbeddingResponse> response) {
                handler.onResponse(((EmbeddingResponse)response.body()).embedding());
            }

            public void onFailure(Call<EmbeddingResponse> call, Throwable t) {
                handler.onFailure(t);
            }
        });
    }

    private <Res> Res execute(Call<Res> call) {
        try {
            retrofit2.Response response = call.execute();
            if (response.isSuccessful()) {
                return (Res)response.body();
            }
            throw new RuntimeException(response.errorBody().string());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <Req, Res> void stream(Req request, String endpoint, final Class<Res> responseClass, final Function<Res, String> partialResponseStringExtractor, final StreamingResponseHandler handler) {
        String requestJson = Json.toJson(request);
        Request okHttpRequest = new Request.Builder().url(this.url + endpoint).post(RequestBody.create((String)requestJson, (MediaType)MediaType.get((String)"application/json; charset=utf-8"))).build();
        EventSourceListener eventSourceListener = new EventSourceListener(){
            private final StringBuilder completeResponseBuilder = new StringBuilder();

            public void onOpen(EventSource eventSource, Response response) {
                log.trace("onOpen() {}", (Object)response);
            }

            public void onEvent(EventSource eventSource, String id, String type, String data) {
                log.trace("onEvent() data: {}", (Object)data);
                if ("[DONE]".equals(data)) {
                    handler.onCompleteResponse(this.completeResponseBuilder.toString());
                    return;
                }
                try {
                    Object response = Json.fromJson(data, responseClass);
                    String partialResponseString = (String)partialResponseStringExtractor.apply(response);
                    if (partialResponseString != null) {
                        this.completeResponseBuilder.append(partialResponseString);
                        handler.onPartialResponse(partialResponseString);
                    }
                }
                catch (Exception e) {
                    handler.onFailure(e);
                }
            }

            public void onClosed(EventSource eventSource) {
                log.trace("onClosed()");
            }

            public void onFailure(EventSource eventSource, Throwable t, Response response) {
                log.trace("onFailure()\nThrowable: {}\nResponse: {}", (Object)t, (Object)response);
                if (t != null) {
                    handler.onFailure(t);
                } else {
                    try {
                        handler.onFailure(new RuntimeException(response.body().string()));
                    }
                    catch (IOException e) {
                        handler.onFailure(e);
                    }
                }
            }
        };
        EventSources.createFactory((OkHttpClient)this.okHttpClient).newEventSource(okHttpRequest, eventSourceListener);
    }

    public static class Builder {
        private String url = "https://api.openai.com/";
        private String apiKey;
        private Duration timeout = Duration.ofSeconds(60L);

        private Builder() {
        }

        public Builder url(String url) {
            if (url == null || url.trim().isEmpty()) {
                throw new IllegalArgumentException("URL cannot be null or empty");
            }
            this.url = url.endsWith("/") ? url : url + "/";
            return this;
        }

        public Builder apiKey(String apiKey) {
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("API key cannot be null or empty. API keys can be generated here: https://platform.openai.com/account/api-keys");
            }
            this.apiKey = apiKey;
            return this;
        }

        public Builder timeout(Duration timeout) {
            if (timeout == null) {
                throw new IllegalArgumentException("Timeout cannot be null");
            }
            this.timeout = timeout;
            return this;
        }

        public OpenAiService build() {
            return new OpenAiService(this);
        }
    }
}

