/*
 * Decompiled with CFR 0.152.
 */
package dev.embeddings4j;

import com.github.jelmerk.knn.DistanceFunction;
import com.github.jelmerk.knn.hnsw.HnswIndex;
import dev.embeddings4j.Embedding;
import dev.embeddings4j.EmbeddingSearchQuery;
import dev.embeddings4j.EmbeddingSearchResult;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractInMemoryVectorDatabase<VectorType extends Comparable<VectorType>> {
    private final HnswIndex<Long, List<VectorType>, Embedding<VectorType>, VectorType> index;

    protected AbstractInMemoryVectorDatabase(int dimensions, int maxSize, DistanceFunction<List<VectorType>, VectorType> distanceFunction) {
        this.index = HnswIndex.newBuilder((int)dimensions, distanceFunction, (int)maxSize).build();
    }

    public List<EmbeddingSearchResult<VectorType>> searchNearest(EmbeddingSearchQuery<VectorType> query) {
        List results = this.index.findNearest(query.reference().vector(), query.maxResults().intValue());
        return results.stream().map(result -> new EmbeddingSearchResult<Comparable>((Embedding)result.item(), (Comparable)result.distance())).collect(Collectors.toList());
    }

    public void insert(Embedding<VectorType> vector) {
        this.index.add(vector);
    }

    public void insertAll(Collection<Embedding<VectorType>> vector) throws InterruptedException {
        this.index.addAll(vector);
    }

    public int size() {
        return this.index.size();
    }
}

