/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.chat;

import dev.ai4j.Tokenizer;
import java.util.Objects;

public abstract class ChatMessage {
    private static final Tokenizer TOKENIZER = new Tokenizer();
    private static final int EXTRA_TOKENS_PER_EACH_CHAT_MESSAGE = 5;
    private final String contents;
    private final int numberOfTokens;

    ChatMessage(String contents) {
        this.contents = contents;
        this.numberOfTokens = ChatMessage.countTokens(contents);
    }

    public String contents() {
        return this.contents;
    }

    public int numberOfTokens() {
        return this.numberOfTokens;
    }

    private static int countTokens(String contents) {
        return TOKENIZER.countTokens(contents) + 5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatMessage that = (ChatMessage)o;
        return Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hash(this.contents);
    }

    public String toString() {
        return "ChatMessage{contents='" + this.contents + '\'' + ", numberOfTokens=" + this.numberOfTokens + '}';
    }
}

