/*
 * Decompiled with CFR 0.152.
 */
package dev.adamko.kxstsgen.core;

import dev.adamko.kxstsgen.KxsTsConfig;
import dev.adamko.kxstsgen.core.TsDeclaration;
import dev.adamko.kxstsgen.core.TsElement;
import dev.adamko.kxstsgen.core.TsElementId;
import dev.adamko.kxstsgen.core.TsLiteral;
import dev.adamko.kxstsgen.core.TsProperty;
import dev.adamko.kxstsgen.core.TsTypeRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001 J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u001dH&J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u001fH&\u00a8\u0006!"}, d2={"Ldev/adamko/kxstsgen/core/TsSourceCodeGenerator;", "", "generateDeclaration", "", "element", "Ldev/adamko/kxstsgen/core/TsDeclaration;", "generateEnum", "enum", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsEnum;", "generateInterface", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsInterface;", "generateMapTypeReference", "tsMap", "Ldev/adamko/kxstsgen/core/TsLiteral$TsMap;", "generateNamespace", "namespace", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsNamespace;", "generatePrimitive", "primitive", "Ldev/adamko/kxstsgen/core/TsLiteral$Primitive;", "generateTuple", "tuple", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsTuple;", "generateTypeAlias", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsTypeAlias;", "generateTypeReference", "typeRef", "Ldev/adamko/kxstsgen/core/TsTypeRef;", "generateTypeUnion", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsTypeUnion;", "groupElementsBy", "Ldev/adamko/kxstsgen/core/TsElement;", "Default", "kxs-ts-gen-core"})
public interface TsSourceCodeGenerator {
    @Nullable
    public String groupElementsBy(@NotNull TsElement var1);

    @NotNull
    public String generateDeclaration(@NotNull TsDeclaration var1);

    @NotNull
    public String generateEnum(@NotNull TsDeclaration.TsEnum var1);

    @NotNull
    public String generateInterface(@NotNull TsDeclaration.TsInterface var1);

    @NotNull
    public String generateNamespace(@NotNull TsDeclaration.TsNamespace var1);

    @NotNull
    public String generateTypeAlias(@NotNull TsDeclaration.TsTypeAlias var1);

    @NotNull
    public String generateTypeUnion(@NotNull TsDeclaration.TsTypeUnion var1);

    @NotNull
    public String generateTuple(@NotNull TsDeclaration.TsTuple var1);

    @NotNull
    public String generateMapTypeReference(@NotNull TsLiteral.TsMap var1);

    @NotNull
    public String generatePrimitive(@NotNull TsLiteral.Primitive var1);

    @NotNull
    public String generateTypeReference(@NotNull TsTypeRef var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\n\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ldev/adamko/kxstsgen/core/TsSourceCodeGenerator$Default;", "Ldev/adamko/kxstsgen/core/TsSourceCodeGenerator;", "config", "Ldev/adamko/kxstsgen/KxsTsConfig;", "(Ldev/adamko/kxstsgen/KxsTsConfig;)V", "generateEnum", "", "enum", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsEnum;", "generateInterface", "element", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsInterface;", "generateInterfaceProperty", "property", "Ldev/adamko/kxstsgen/core/TsProperty;", "generateMapTypeReference", "tsMap", "Ldev/adamko/kxstsgen/core/TsLiteral$TsMap;", "generateNamespace", "namespace", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsNamespace;", "generatePrimitive", "primitive", "Ldev/adamko/kxstsgen/core/TsLiteral$Primitive;", "generateTuple", "tuple", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsTuple;", "generateTypeAlias", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsTypeAlias;", "generateTypeReference", "typeRef", "Ldev/adamko/kxstsgen/core/TsTypeRef;", "generateTypeUnion", "Ldev/adamko/kxstsgen/core/TsDeclaration$TsTypeUnion;", "groupElementsBy", "Ldev/adamko/kxstsgen/core/TsElement;", "kxs-ts-gen-core"})
    @SourceDebugExtension(value={"SMAP\nTsSourceCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TsSourceCodeGenerator.kt\ndev/adamko/kxstsgen/core/TsSourceCodeGenerator$Default\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1024#2,9:258\n1174#2:267\n1175#2:269\n1033#2:270\n1#3:268\n1549#4:271\n1620#4,3:272\n*S KotlinDebug\n*F\n+ 1 TsSourceCodeGenerator.kt\ndev/adamko/kxstsgen/core/TsSourceCodeGenerator$Default\n*L\n134#1:258,9\n134#1:267\n134#1:269\n134#1:270\n134#1:268\n157#1:271\n157#1:272,3\n*E\n"})
    public static class Default
    implements TsSourceCodeGenerator {
        @NotNull
        private final KxsTsConfig config;

        public Default(@NotNull KxsTsConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public String groupElementsBy(@NotNull TsElement element) {
            String string;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KxsTsConfig.NamespaceConfig namespaceConfig = this.config.getNamespaceConfig();
            if (namespaceConfig instanceof KxsTsConfig.NamespaceConfig.Static) {
                string = ((KxsTsConfig.NamespaceConfig.Static)this.config.getNamespaceConfig()).unbox-impl();
                return string;
            } else {
                if (Intrinsics.areEqual((Object)namespaceConfig, (Object)KxsTsConfig.NamespaceConfig.Disabled.INSTANCE)) {
                    return "";
                }
                if (!Intrinsics.areEqual((Object)namespaceConfig, (Object)KxsTsConfig.NamespaceConfig.DescriptorNamePrefix.INSTANCE)) throw new NoWhenBranchMatchedException();
                TsElement tsElement = element;
                if (tsElement instanceof TsLiteral) {
                    return "";
                }
                if (!(tsElement instanceof TsDeclaration)) throw new NoWhenBranchMatchedException();
                string = TsElementId.getNamespace-impl(((TsDeclaration)element).getId-VSguWwg());
            }
            return string;
        }

        @Override
        @NotNull
        public String generateNamespace(@NotNull TsDeclaration.TsNamespace namespace) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            String namespaceContent2 = CollectionsKt.joinToString$default((Iterable)namespace.getMembers(), (CharSequence)this.config.getDeclarationSeparator(), null, null, (int)0, null, (Function1)((Function1)new Function1<TsDeclaration, CharSequence>(this){
                final /* synthetic */ Default this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TsDeclaration declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    return this.this$0.generateDeclaration(declaration);
                }
            }), (int)30, null);
            StringBuilder $this$generateNamespace_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$generateNamespace_u24lambda_u240.append("export namespace " + TsElementId.getName-impl(namespace.getId-VSguWwg()) + " {");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            if (!StringsKt.isBlank((CharSequence)namespaceContent2)) {
                StringBuilder stringBuilder3 = $this$generateNamespace_u24lambda_u240.append(StringsKt.prependIndent((String)namespaceContent2, (String)this.config.getIndent()));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
            $this$generateNamespace_u24lambda_u240.append("}");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @Override
        @NotNull
        public String generateEnum(@NotNull TsDeclaration.TsEnum tsEnum) {
            Intrinsics.checkNotNullParameter((Object)tsEnum, (String)"enum");
            String enumMembers2 = CollectionsKt.joinToString$default((Iterable)tsEnum.getMembers(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<TsProperty, CharSequence>(this){
                final /* synthetic */ Default this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TsProperty member) {
                    Intrinsics.checkNotNullParameter((Object)member, (String)"member");
                    return StringsKt.prependIndent((String)StringsKt.trimMargin$default((String)("\n          |" + member.getName() + " = \"" + this.this$0.generateTypeReference(member.getTypeRef()) + "\",\n        "), null, (int)1, null), (String)Default.access$getConfig$p(this.this$0).getIndent());
                }
            }), (int)30, null);
            return StringsKt.trimMargin$default((String)("\n        |export enum " + TsElementId.getName-impl(tsEnum.getId-VSguWwg()) + " {\n        |" + enumMembers2 + "\n        |}\n      "), null, (int)1, null);
        }

        @Override
        @NotNull
        public String generateInterface(@NotNull TsDeclaration.TsInterface element) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String properties2 = CollectionsKt.joinToString$default((Iterable)element.getProperties(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<TsProperty, CharSequence>(this){
                final /* synthetic */ Default this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TsProperty it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.generateInterfaceProperty(it);
                }
            }), (int)30, null);
            StringBuilder $this$generateInterface_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$generateInterface_u24lambda_u241.append("export interface " + TsElementId.getName-impl(element.getId-VSguWwg()) + " {");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            if (!StringsKt.isBlank((CharSequence)properties2)) {
                StringBuilder stringBuilder3 = $this$generateInterface_u24lambda_u241.append(StringsKt.prependIndent((String)properties2, (String)this.config.getIndent()));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
            $this$generateInterface_u24lambda_u241.append("}");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public String generateInterfaceProperty(@NotNull TsProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            String separator = property.getOptional() ? "?: " : ": ";
            String propertyType = this.generateTypeReference(property.getTypeRef());
            return property.getName() + separator + propertyType + ";";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String generateTypeAlias(@NotNull TsDeclaration.TsTypeAlias element) {
            String string;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String aliasedRef = this.generateTypeReference(element.getTypeRef());
            KxsTsConfig.TypeAliasTypingConfig typeAliasTypingConfig = this.config.getTypeAliasTyping();
            if (Intrinsics.areEqual((Object)typeAliasTypingConfig, (Object)KxsTsConfig.TypeAliasTypingConfig.None.INSTANCE)) {
                string = StringsKt.trimMargin$default((String)("\n            |export type " + TsElementId.getName-impl(element.getId-VSguWwg()) + " = " + aliasedRef + ";\n          "), null, (int)1, null);
            } else if (Intrinsics.areEqual((Object)typeAliasTypingConfig, (Object)KxsTsConfig.TypeAliasTypingConfig.BrandTyping.INSTANCE)) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                CharSequence charSequence = TsElementId.getName-impl(element.getId-VSguWwg());
                boolean $i$f$mapNotNull = false;
                void var7_6 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                for (int i = 0; i < $this$forEach$iv$iv$iv.length(); ++i) {
                    Character it$iv$iv;
                    char element$iv$iv$iv;
                    char element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv.charAt(i);
                    boolean bl = false;
                    char c = element$iv$iv;
                    boolean bl2 = false;
                    if ((c == '.' ? Character.valueOf('_') : (!Character.isLetter(c) ? null : Character.valueOf(c))) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                String brandType = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                string = StringsKt.trimMargin$default((String)("\n            |export type " + TsElementId.getName-impl(element.getId-VSguWwg()) + " = " + aliasedRef + " & { __" + brandType + "__: void };\n          "), null, (int)1, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String generateTypeUnion(@NotNull TsDeclaration.TsTypeUnion element) {
            String string;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getTypeRefs().isEmpty()) {
                string = StringsKt.trimMargin$default((String)("\n          |export type " + TsElementId.getName-impl(element.getId-VSguWwg()) + " = " + this.generatePrimitive(TsLiteral.Primitive.TsUnknown.INSTANCE) + ";\n        "), null, (int)1, null);
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = element.getTypeRefs();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TsTypeRef tsTypeRef = (TsTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.config.getIndent() + "| " + this.generateTypeReference((TsTypeRef)it));
                }
                String aliases = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                string = StringsKt.trimMargin((String)("\n          \u00a6export type " + TsElementId.getName-impl(element.getId-VSguWwg()) + " =\n          \u00a6" + aliases + ";\n        "), (String)"\u00a6");
            }
            return string;
        }

        @Override
        @NotNull
        public String generateTuple(@NotNull TsDeclaration.TsTuple tuple) {
            Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
            String types2 = CollectionsKt.joinToString$default((Iterable)tuple.getElements(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<TsProperty, CharSequence>(this){
                final /* synthetic */ Default this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TsProperty property) {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    String optionalMarker = property.getOptional() ? "?" : "";
                    String typeRef = this.this$0.generateTypeReference(property.getTypeRef());
                    return Default.access$getConfig$p(this.this$0).getIndent() + property.getName() + ": " + typeRef + optionalMarker + ",";
                }
            }), (int)30, null);
            return StringsKt.trimMargin((String)("\n        \u00a6export type " + TsElementId.getName-impl(tuple.getId-VSguWwg()) + " = [\n        \u00a6" + types2 + "\n        \u00a6];\n      "), (String)"\u00a6");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public String generateTypeReference(@NotNull TsTypeRef typeRef) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
            Object object2 = typeRef;
            if (object2 instanceof TsTypeRef.Literal) {
                TsLiteral tsLiteral = ((TsTypeRef.Literal)typeRef).getElement();
                if (tsLiteral instanceof TsLiteral.Primitive) {
                    object = this.generatePrimitive((TsLiteral.Primitive)((TsTypeRef.Literal)typeRef).getElement());
                } else if (tsLiteral instanceof TsLiteral.TsList) {
                    String valueTypeRef = this.generateTypeReference(((TsLiteral.TsList)((TsTypeRef.Literal)typeRef).getElement()).getValueTypeRef());
                    object = valueTypeRef + "[]";
                } else if (tsLiteral instanceof TsLiteral.TsMap) {
                    object = this.generateMapTypeReference((TsLiteral.TsMap)((TsTypeRef.Literal)typeRef).getElement());
                } else {
                    if (!(tsLiteral instanceof TsLiteral.Custom)) throw new NoWhenBranchMatchedException();
                    object = ((TsLiteral.Custom)((TsTypeRef.Literal)typeRef).getElement()).unbox-impl();
                }
            } else {
                if (!(object2 instanceof TsTypeRef.Declaration)) throw new NoWhenBranchMatchedException();
                if (((TsTypeRef.Declaration)typeRef).getParent() != null) {
                    String parentRef = this.generateTypeReference(((TsTypeRef.Declaration)typeRef).getParent());
                    object = parentRef + "." + TsElementId.getName-impl(((TsTypeRef.Declaration)typeRef).getId-VSguWwg());
                } else {
                    object = TsElementId.getName-impl(((TsTypeRef.Declaration)typeRef).getId-VSguWwg());
                }
            }
            String plainType = object;
            Object $this$generateTypeReference_u24lambda_u244 = object2 = new StringBuilder();
            boolean bl = false;
            ((StringBuilder)$this$generateTypeReference_u24lambda_u244).append(plainType);
            if (typeRef.getNullable()) {
                ((StringBuilder)$this$generateTypeReference_u24lambda_u244).append(" | ");
                ((StringBuilder)$this$generateTypeReference_u24lambda_u244).append(this.generatePrimitive(TsLiteral.Primitive.TsNull.INSTANCE));
            }
            String string = ((StringBuilder)object2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @Override
        @NotNull
        public String generatePrimitive(@NotNull TsLiteral.Primitive primitive) {
            String string;
            Intrinsics.checkNotNullParameter((Object)primitive, (String)"primitive");
            TsLiteral.Primitive primitive2 = primitive;
            if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsString.INSTANCE)) {
                string = "string";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsNumber.INSTANCE)) {
                string = "number";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsBoolean.INSTANCE)) {
                string = "boolean";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsObject.INSTANCE)) {
                string = "object";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsAny.INSTANCE)) {
                string = "any";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsNever.INSTANCE)) {
                string = "never";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsNull.INSTANCE)) {
                string = "null";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsUndefined.INSTANCE)) {
                string = "undefined";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsUnknown.INSTANCE)) {
                string = "unknown";
            } else if (Intrinsics.areEqual((Object)primitive2, (Object)TsLiteral.Primitive.TsVoid.INSTANCE)) {
                string = "void";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Override
        @NotNull
        public String generateMapTypeReference(@NotNull TsLiteral.TsMap tsMap) {
            String string;
            Intrinsics.checkNotNullParameter((Object)tsMap, (String)"tsMap");
            String keyTypeRef = this.generateTypeReference(tsMap.getKeyTypeRef());
            String valueTypeRef = this.generateTypeReference(tsMap.getValueTypeRef());
            switch (WhenMappings.$EnumSwitchMapping$0[tsMap.getType().ordinal()]) {
                case 1: {
                    string = "{ [key: " + keyTypeRef + "]: " + valueTypeRef + " }";
                    break;
                }
                case 2: {
                    string = "{ [key in " + keyTypeRef + "]: " + valueTypeRef + " }";
                    break;
                }
                case 3: {
                    string = "Map<" + keyTypeRef + ", " + valueTypeRef + ">";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Override
        @NotNull
        public String generateDeclaration(@NotNull TsDeclaration element) {
            return DefaultImpls.generateDeclaration(this, element);
        }

        public static final /* synthetic */ KxsTsConfig access$getConfig$p(Default $this) {
            return $this.config;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TsLiteral.TsMap.Type.values().length];
                try {
                    nArray[TsLiteral.TsMap.Type.INDEX_SIGNATURE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TsLiteral.TsMap.Type.MAPPED_OBJECT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TsLiteral.TsMap.Type.MAP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String generateDeclaration(@NotNull TsSourceCodeGenerator $this, @NotNull TsDeclaration element) {
            String string;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TsDeclaration tsDeclaration = element;
            if (tsDeclaration instanceof TsDeclaration.TsEnum) {
                string = $this.generateEnum((TsDeclaration.TsEnum)element);
            } else if (tsDeclaration instanceof TsDeclaration.TsInterface) {
                string = $this.generateInterface((TsDeclaration.TsInterface)element);
            } else if (tsDeclaration instanceof TsDeclaration.TsNamespace) {
                string = $this.generateNamespace((TsDeclaration.TsNamespace)element);
            } else if (tsDeclaration instanceof TsDeclaration.TsTypeUnion) {
                string = $this.generateTypeUnion((TsDeclaration.TsTypeUnion)element);
            } else if (tsDeclaration instanceof TsDeclaration.TsTypeAlias) {
                string = $this.generateTypeAlias((TsDeclaration.TsTypeAlias)element);
            } else if (tsDeclaration instanceof TsDeclaration.TsTuple) {
                string = $this.generateTuple((TsDeclaration.TsTuple)element);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
    }
}

