/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.to2mbn.jmccc.auth.AuthenticationException;
import org.to2mbn.jmccc.auth.yggdrasil.core.GameProfile;
import org.to2mbn.jmccc.auth.yggdrasil.core.GameProfileCallback;
import org.to2mbn.jmccc.auth.yggdrasil.core.ProfileNotFoundException;
import org.to2mbn.jmccc.auth.yggdrasil.core.ProfileService;
import org.to2mbn.jmccc.auth.yggdrasil.core.PropertiesGameProfile;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpRequester;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpUtils;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.Texture;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.TextureType;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.Textures;
import org.to2mbn.jmccc.auth.yggdrasil.core.util.Base64;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.AbstractYggdrasilService;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.PropertiesDeserializer;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.YggdrasilAPIProvider;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.util.IOUtils;
import org.to2mbn.jmccc.util.UUIDUtils;

class YggdrasilProfileService
extends AbstractYggdrasilService
implements ProfileService {
    private static final Logger LOGGER = Logger.getLogger(YggdrasilProfileService.class.getCanonicalName());
    private static final int PROFILES_PER_REQUEST = 100;

    public YggdrasilProfileService(HttpRequester requester, PropertiesDeserializer propertiesDeserializer, YggdrasilAPIProvider api) {
        super(requester, propertiesDeserializer, api);
    }

    @Override
    public PropertiesGameProfile getGameProfile(final UUID profileUUID) throws AuthenticationException {
        Objects.requireNonNull(profileUUID);
        return this.invokeOperation(new Callable<PropertiesGameProfile>(){

            @Override
            public PropertiesGameProfile call() throws Exception {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("unsigned", "false");
                JSONObject response = YggdrasilProfileService.this.nullableJsonObject(YggdrasilProfileService.this.requester.request("GET", HttpUtils.withUrlArguments(YggdrasilProfileService.this.api.profile(profileUUID), arguments)));
                if (response == null) {
                    return null;
                }
                JSONArray jsonProperties = response.optJSONArray("properties");
                Map<String, String> properties = jsonProperties == null ? null : Collections.unmodifiableMap(YggdrasilProfileService.this.propertiesDeserializer.toProperties(jsonProperties, true));
                return new PropertiesGameProfile(UUIDUtils.toUUID((String)response.getString("id")), response.getString("name"), properties);
            }
        });
    }

    @Override
    public PropertiesGameProfile fillProperties(GameProfile profile) throws AuthenticationException {
        Objects.requireNonNull(profile);
        if (profile instanceof PropertiesGameProfile) {
            return (PropertiesGameProfile)profile;
        }
        PropertiesGameProfile result = this.getGameProfile(profile.getUUID());
        if (result == null) {
            result = new PropertiesGameProfile(profile.getUUID(), profile.getName(), null);
        }
        return result;
    }

    @Override
    public Map<TextureType, Texture> getTextures(final PropertiesGameProfile profile) throws AuthenticationException {
        Objects.requireNonNull(profile);
        return this.invokeOperation(new Callable<Map<TextureType, Texture>>(){

            @Override
            public Map<TextureType, Texture> call() throws Exception {
                return YggdrasilProfileService.this.parseTextures(profile.getProperties());
            }
        });
    }

    private Map<TextureType, Texture> parseTextures(Map<String, String> properties) {
        if (properties == null) {
            return null;
        }
        String encodedTextures = properties.get("textures");
        if (encodedTextures == null) {
            return null;
        }
        JSONObject payload = IOUtils.toJson((byte[])Base64.decode(encodedTextures.toCharArray()));
        EnumMap<TextureType, Texture> result = new EnumMap<TextureType, Texture>(TextureType.class);
        JSONObject textures = payload.getJSONObject("textures");
        for (String textureTypeName : textures.keySet()) {
            TextureType textureType;
            try {
                textureType = TextureType.valueOf(textureTypeName);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Unknown texture type: " + textureTypeName, e);
                continue;
            }
            JSONObject texureJson = textures.getJSONObject(textureTypeName);
            try {
                result.put(textureType, this.parseTexture(texureJson));
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Couldn't parse texture: " + texureJson, e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private Texture parseTexture(JSONObject json) throws MalformedURLException {
        String url = json.getString("url");
        TreeMap<String, String> metadata = null;
        if (json.has("metadata")) {
            metadata = new TreeMap<String, String>();
            JSONObject metadataJson = json.getJSONObject("metadata");
            for (Object rawtypeKey : metadataJson.keySet()) {
                String key = (String)rawtypeKey;
                String value = metadataJson.getString(key);
                metadata.put(key, value);
            }
        }
        return Textures.createTexture(url, metadata == null ? null : Collections.unmodifiableMap(metadata));
    }

    @Override
    public GameProfile lookupGameProfile(String name) throws AuthenticationException {
        String url;
        Objects.requireNonNull(name);
        try {
            url = this.api.profileByUsername(name);
        }
        catch (UnsupportedOperationException e) {
            try {
                this.api.profilesLookup();
            }
            catch (UnsupportedOperationException e1) {
                throw new AuthenticationException("Unsupported operation", (Throwable)e);
            }
            final AtomicReference resultWrapper = new AtomicReference();
            this.lookupGameProfiles(Collections.singleton(name), new GameProfileCallback(){

                @Override
                public void failed(String name, AuthenticationException e) {
                    resultWrapper.set(e);
                }

                @Override
                public void completed(GameProfile profile) {
                    resultWrapper.set(profile);
                }
            });
            Object result = resultWrapper.get();
            if (result instanceof GameProfile) {
                return (GameProfile)result;
            }
            AuthenticationException exception = (AuthenticationException)result;
            if (exception instanceof ProfileNotFoundException) {
                return null;
            }
            throw exception;
        }
        return this.invokeOperation(new Callable<GameProfile>(){

            @Override
            public GameProfile call() throws Exception {
                return YggdrasilProfileService.this.getAndParseGameProfile(url);
            }
        });
    }

    @Override
    public GameProfile lookupGameProfile(final String name, final long timestamp) throws AuthenticationException {
        Objects.requireNonNull(name);
        return this.invokeOperation(new Callable<GameProfile>(){

            @Override
            public GameProfile call() throws Exception {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("at", timestamp / 1000L);
                return YggdrasilProfileService.this.getAndParseGameProfile(HttpUtils.withUrlArguments(YggdrasilProfileService.this.api.profileByUsername(name), arguments));
            }
        });
    }

    private GameProfile getAndParseGameProfile(String url) throws AuthenticationException, JSONException, IOException {
        return this.parseGameProfile(this.nullableJsonObject(this.requester.request("GET", url)));
    }

    @Override
    public void lookupGameProfiles(Set<String> names, GameProfileCallback callback) {
        String url;
        Objects.requireNonNull(names);
        Objects.requireNonNull(callback);
        try {
            url = this.api.profilesLookup();
        }
        catch (UnsupportedOperationException e) {
            for (String name : names) {
                try {
                    GameProfile result = this.lookupGameProfile(name);
                    if (result == null) {
                        callback.failed(name, new ProfileNotFoundException(name));
                        continue;
                    }
                    callback.completed(result);
                }
                catch (AuthenticationException e1) {
                    callback.failed(name, e1);
                }
            }
            return;
        }
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            HashSet<String> lookingUp = new HashSet<String>();
            for (int i = 0; i < 100 && it.hasNext(); ++i) {
                lookingUp.add(it.next().toLowerCase());
            }
            final JSONArray request = new JSONArray(lookingUp);
            Set<GameProfile> queried = null;
            try {
                queried = this.invokeOperation(new Callable<Set<GameProfile>>(){

                    @Override
                    public Set<GameProfile> call() throws Exception {
                        JSONArray response = YggdrasilProfileService.this.requireJsonArray(YggdrasilProfileService.this.requester.requestWithPayload("POST", url, request, "application/json; charset=utf-8"));
                        HashSet<GameProfile> result = new HashSet<GameProfile>();
                        for (Object element : response) {
                            result.add(YggdrasilProfileService.this.parseGameProfile((JSONObject)element));
                        }
                        return result;
                    }
                });
            }
            catch (AuthenticationException e) {
                for (String name : lookingUp) {
                    callback.failed(name, e);
                }
            }
            if (queried == null) continue;
            for (GameProfile profile : queried) {
                callback.completed(profile);
                lookingUp.remove(profile.getName().toLowerCase());
            }
            for (String missing : lookingUp) {
                callback.failed(missing, new ProfileNotFoundException(missing));
            }
        }
    }
}

