/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.to2mbn.jmccc.auth.AuthenticationException;
import org.to2mbn.jmccc.auth.yggdrasil.core.Agent;
import org.to2mbn.jmccc.auth.yggdrasil.core.AuthenticationService;
import org.to2mbn.jmccc.auth.yggdrasil.core.GameProfile;
import org.to2mbn.jmccc.auth.yggdrasil.core.RemoteAuthenticationException;
import org.to2mbn.jmccc.auth.yggdrasil.core.Session;
import org.to2mbn.jmccc.auth.yggdrasil.core.UserType;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpRequester;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.AbstractYggdrasilService;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.PropertiesDeserializer;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.YggdrasilAPIProvider;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.util.UUIDUtils;

class YggdrasilAuthenticationService
extends AbstractYggdrasilService
implements AuthenticationService {
    private Agent agent;

    public YggdrasilAuthenticationService(HttpRequester requester, PropertiesDeserializer propertiesDeserializer, YggdrasilAPIProvider api, Agent agent) {
        super(requester, propertiesDeserializer, api);
        this.agent = agent;
    }

    @Override
    public Session login(String username, String password, final String clientToken) throws AuthenticationException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        Objects.requireNonNull(clientToken);
        final HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("agent", (Object)this.agent);
        request.put("username", username);
        request.put("password", password);
        request.put("clientToken", clientToken);
        request.put("requestUser", true);
        return this.invokeOperation(new Callable<Session>(){

            @Override
            public Session call() throws Exception {
                return YggdrasilAuthenticationService.this.handleAuthResponse(YggdrasilAuthenticationService.this.requester.requestWithPayload("POST", YggdrasilAuthenticationService.this.api.authenticate(), new JSONObject(request), "application/json; charset=utf-8"), clientToken);
            }
        });
    }

    @Override
    public Session refresh(String clientToken, String accessToken) throws AuthenticationException {
        return this.selectProfile(clientToken, accessToken, null);
    }

    @Override
    public Session selectProfile(final String clientToken, String accessToken, GameProfile profile) throws AuthenticationException {
        Objects.requireNonNull(clientToken);
        Objects.requireNonNull(accessToken);
        final HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("clientToken", clientToken);
        request.put("accessToken", accessToken);
        request.put("requestUser", true);
        if (profile != null) {
            JSONObject selectedProfile = new JSONObject();
            selectedProfile.put("id", (Object)UUIDUtils.unsign((UUID)profile.getUUID()));
            selectedProfile.put("name", (Object)profile.getName());
            request.put("selectedProfile", selectedProfile);
        }
        return this.invokeOperation(new Callable<Session>(){

            @Override
            public Session call() throws Exception {
                return YggdrasilAuthenticationService.this.handleAuthResponse(YggdrasilAuthenticationService.this.requester.requestWithPayload("POST", YggdrasilAuthenticationService.this.api.refresh(), new JSONObject(request), "application/json; charset=utf-8"), clientToken);
            }
        });
    }

    @Override
    public boolean validate(String accessToken) throws AuthenticationException {
        return this.validate(null, accessToken);
    }

    @Override
    public boolean validate(String clientToken, String accessToken) throws AuthenticationException {
        Objects.requireNonNull(accessToken);
        final HashMap<String, String> request = new HashMap<String, String>();
        if (clientToken != null) {
            request.put("clientToken", clientToken);
        }
        request.put("accessToken", accessToken);
        return this.invokeOperation(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    YggdrasilAuthenticationService.this.requireEmpty(YggdrasilAuthenticationService.this.requester.requestWithPayload("POST", YggdrasilAuthenticationService.this.api.validate(), new JSONObject(request), "application/json; charset=utf-8"));
                    return true;
                }
                catch (RemoteAuthenticationException e) {
                    if ("ForbiddenOperationException".equals(e.getRemoteExceptionName())) {
                        return false;
                    }
                    throw e;
                }
            }
        });
    }

    @Override
    public void invalidate(String clientToken, String accessToken) throws AuthenticationException {
        Objects.requireNonNull(clientToken);
        Objects.requireNonNull(accessToken);
        final HashMap<String, String> request = new HashMap<String, String>();
        request.put("clientToken", clientToken);
        request.put("accessToken", accessToken);
        this.invokeOperation(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                YggdrasilAuthenticationService.this.requireEmpty(YggdrasilAuthenticationService.this.requester.requestWithPayload("POST", YggdrasilAuthenticationService.this.api.invalidate(), new JSONObject(request), "application/json; charset=utf-8"));
                return null;
            }
        });
    }

    @Override
    public void signout(String username, String password) throws AuthenticationException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        final HashMap<String, String> request = new HashMap<String, String>();
        request.put("username", username);
        request.put("password", password);
        this.invokeOperation(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                YggdrasilAuthenticationService.this.requireEmpty(YggdrasilAuthenticationService.this.requester.requestWithPayload("POST", YggdrasilAuthenticationService.this.api.signout(), new JSONObject(request), "application/json; charset=utf-8"));
                return null;
            }
        });
    }

    public Agent getAgent() {
        return this.agent;
    }

    private Session handleAuthResponse(Object rawResponse, String clientToken) throws AuthenticationException, GeneralSecurityException {
        GameProfile[] availableProfiles;
        JSONObject response = this.requireJsonObject(rawResponse);
        if (clientToken != null && !clientToken.equals(response.getString("clientToken"))) {
            throw new AuthenticationException("clientToken changed from " + clientToken + " to " + response.getString("clientToken"));
        }
        String accessToken = response.getString("accessToken");
        JSONObject userjson = response.optJSONObject("user");
        String userId = userjson == null ? null : userjson.optString("id", null);
        JSONArray propertiesJson = userjson == null ? null : userjson.optJSONArray("properties");
        Map<String, String> userProperties = propertiesJson == null ? null : Collections.unmodifiableMap(this.propertiesDeserializer.toProperties(propertiesJson, false));
        GameProfile selectedProfile = this.parseGameProfile(response.optJSONObject("selectedProfile"));
        JSONArray profilesArray = response.optJSONArray("availableProfiles");
        if (profilesArray == null) {
            availableProfiles = null;
        } else {
            availableProfiles = new GameProfile[profilesArray.length()];
            for (int i = 0; i < profilesArray.length(); ++i) {
                availableProfiles[i] = this.parseGameProfile(profilesArray.getJSONObject(i));
            }
        }
        return new Session(clientToken, accessToken, selectedProfile, availableProfiles, userId, userProperties, UserType.MOJANG);
    }
}

