/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.texture;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.Texture;

public class ByteArrayTexture
implements Texture {
    private byte[] data;
    private Map<String, String> metadata;

    public ByteArrayTexture(byte[] data, Map<String, String> metadata) {
        this.data = Objects.requireNonNull(data);
        this.metadata = metadata;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public InputStream openStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public String toString() {
        return String.format("ByteArrayTexture [length=%d, metadata=%s]", this.data.length, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteArrayTexture) {
            ByteArrayTexture another = (ByteArrayTexture)obj;
            return Objects.equals(this.metadata, another.metadata) && Arrays.equals(this.data, another.data);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.data.length + Objects.hashCode(this.metadata);
    }
}

