/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.io;

import java.util.concurrent.Callable;
import org.to2mbn.jmccc.auth.AuthenticationException;
import org.to2mbn.jmccc.auth.yggdrasil.core.RemoteAuthenticationException;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpRequester;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.internal.org.json.JSONTokener;

public class AbstractClientService {
    protected final HttpRequester requester;

    public AbstractClientService(HttpRequester requester) {
        this.requester = requester;
    }

    private static Object toJsonIfNecessary(Object obj) throws JSONException {
        if (obj instanceof String) {
            return AbstractClientService.toJson((String)obj);
        }
        return obj;
    }

    private static Object toJson(String json) throws JSONException {
        if (json == null || json.trim().isEmpty()) {
            return null;
        }
        try {
            JSONTokener tokener = new JSONTokener(json);
            char next = tokener.nextClean();
            tokener.back();
            if (next == '{') {
                return new JSONObject(tokener);
            }
            if (next == '[') {
                return new JSONArray(tokener);
            }
        }
        catch (JSONException e) {
            throw new JSONException("Couldn't resolve json: " + json, (Throwable)e);
        }
        throw new JSONException("Couldn't resolve json: " + json);
    }

    protected JSONObject nullableJsonObject(Object response) throws AuthenticationException, JSONException {
        if ((response = AbstractClientService.toJsonIfNecessary(response)) == null) {
            return null;
        }
        return this.requireJsonObject(response);
    }

    protected JSONArray nullableJsonArray(Object response) throws AuthenticationException, JSONException {
        if ((response = AbstractClientService.toJsonIfNecessary(response)) == null) {
            return null;
        }
        return this.requireJsonArray(response);
    }

    protected JSONObject requireJsonObject(Object response) throws AuthenticationException, JSONException {
        if ((response = AbstractClientService.toJsonIfNecessary(response)) instanceof JSONObject) {
            JSONObject cast = (JSONObject)response;
            this.tryThrowRemoteException(cast);
            return cast;
        }
        throw new JSONException("Illegal response: " + response);
    }

    protected JSONArray requireJsonArray(Object response) throws AuthenticationException, JSONException {
        if ((response = AbstractClientService.toJsonIfNecessary(response)) instanceof JSONArray) {
            return (JSONArray)response;
        }
        if (response instanceof JSONObject) {
            this.tryThrowRemoteException((JSONObject)response);
        }
        throw new JSONException("Illegal response: " + response);
    }

    protected void requireEmpty(Object response) throws AuthenticationException, JSONException {
        if ((response = AbstractClientService.toJsonIfNecessary(response)) == null) {
            return;
        }
        if (response instanceof JSONObject) {
            this.tryThrowRemoteException((JSONObject)response);
        }
        throw new JSONException("Illegal response: " + response);
    }

    protected <R> R invokeOperation(Callable<R> operation) throws AuthenticationException {
        try {
            return operation.call();
        }
        catch (Exception e) {
            if (e instanceof AuthenticationException) {
                throw (AuthenticationException)((Object)e);
            }
            throw new AuthenticationException((Throwable)e);
        }
    }

    private void tryThrowRemoteException(JSONObject response) throws AuthenticationException, JSONException {
        try {
            if (response.has("error") && !response.getString("error").isEmpty()) {
                throw new RemoteAuthenticationException(response.getString("error"), response.optString("errorMessage", null), response.optString("cause", null));
            }
        }
        catch (JSONException e) {
            throw new JSONException("Couldn't parse response: " + response, (Throwable)e);
        }
    }
}

