/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.to2mbn.jmccc.auth.AuthInfo;
import org.to2mbn.jmccc.auth.AuthenticationException;
import org.to2mbn.jmccc.auth.Authenticator;
import org.to2mbn.jmccc.auth.yggdrasil.CharacterSelector;
import org.to2mbn.jmccc.auth.yggdrasil.DefaultCharacterSelector;
import org.to2mbn.jmccc.auth.yggdrasil.SessionCredential;
import org.to2mbn.jmccc.auth.yggdrasil.core.AuthenticationService;
import org.to2mbn.jmccc.auth.yggdrasil.core.GameProfile;
import org.to2mbn.jmccc.auth.yggdrasil.core.Session;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.YggdrasilAuthenticationServiceBuilder;
import org.to2mbn.jmccc.util.UUIDUtils;

public class YggdrasilAuthenticator
implements Authenticator,
SessionCredential,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient AuthenticationService authenticationService;
    private volatile Session authResult;

    public YggdrasilAuthenticator() {
        this(YggdrasilAuthenticationServiceBuilder.buildDefault());
    }

    public YggdrasilAuthenticator(AuthenticationService sessionService) {
        Objects.requireNonNull(sessionService);
        this.authenticationService = sessionService;
    }

    public static PasswordProvider createPasswordProvider(final String username, final String password, final CharacterSelector characterSelector) {
        return new PasswordProvider(){

            @Override
            public String getUsername() throws AuthenticationException {
                return username;
            }

            @Override
            public String getPassword() throws AuthenticationException {
                return password;
            }

            @Override
            public CharacterSelector getCharacterSelector() {
                return characterSelector;
            }
        };
    }

    public static YggdrasilAuthenticator token(String clientToken, String accessToken) throws AuthenticationException {
        return YggdrasilAuthenticator.token(clientToken, accessToken, YggdrasilAuthenticationServiceBuilder.buildDefault());
    }

    public static YggdrasilAuthenticator token(String clientToken, String accessToken, AuthenticationService service) throws AuthenticationException {
        Objects.requireNonNull(clientToken);
        Objects.requireNonNull(accessToken);
        Objects.requireNonNull(service);
        YggdrasilAuthenticator auth = new YggdrasilAuthenticator(service);
        auth.refreshWithToken(clientToken, accessToken);
        return auth;
    }

    public static YggdrasilAuthenticator password(String username, String password) throws AuthenticationException {
        return YggdrasilAuthenticator.password(username, password, null);
    }

    public static YggdrasilAuthenticator password(String username, String password, CharacterSelector characterSelector) throws AuthenticationException {
        return YggdrasilAuthenticator.password(username, password, characterSelector, UUIDUtils.randomUnsignedUUID());
    }

    public static YggdrasilAuthenticator password(String username, String password, CharacterSelector characterSelector, String clientToken) throws AuthenticationException {
        return YggdrasilAuthenticator.password(username, password, characterSelector, clientToken, YggdrasilAuthenticationServiceBuilder.buildDefault());
    }

    public static YggdrasilAuthenticator password(String username, String password, CharacterSelector characterSelector, String clientToken, AuthenticationService service) throws AuthenticationException {
        return YggdrasilAuthenticator.password(service, YggdrasilAuthenticator.createPasswordProvider(username, password, characterSelector), clientToken);
    }

    public static YggdrasilAuthenticator password(AuthenticationService service, PasswordProvider passwordProvider, String clientToken) throws AuthenticationException {
        Objects.requireNonNull(service);
        Objects.requireNonNull(passwordProvider);
        Objects.requireNonNull(clientToken);
        YggdrasilAuthenticator auth = new YggdrasilAuthenticator(service);
        auth.refreshWithPassword(passwordProvider);
        return auth;
    }

    public synchronized AuthInfo auth() throws AuthenticationException {
        GameProfile selectedProfile = this.session().getSelectedProfile();
        if (selectedProfile == null) {
            throw new AuthenticationException("no profile is available");
        }
        Map<String, String> properties = this.authResult.getProperties();
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        return new AuthInfo(selectedProfile.getName(), this.authResult.getAccessToken(), selectedProfile.getUUID(), properties, this.authResult.getUserType().getName());
    }

    @Override
    public synchronized Session session() throws AuthenticationException {
        if (this.authResult == null || !this.authenticationService.validate(this.authResult.getClientToken(), this.authResult.getAccessToken())) {
            this.refresh();
        }
        if (this.authResult == null) {
            throw new AuthenticationException("no authentication is available");
        }
        return this.authResult;
    }

    public synchronized void refresh() throws AuthenticationException {
        if (this.authResult == null) {
            PasswordProvider passwordProvider = this.tryPasswordLogin();
            if (passwordProvider == null) {
                throw new AuthenticationException("no more authentication methods to try");
            }
            this.refreshWithPassword(passwordProvider);
        } else {
            try {
                this.refreshWithToken(this.authResult.getClientToken(), this.authResult.getAccessToken());
            }
            catch (AuthenticationException e) {
                PasswordProvider passwordProvider = this.tryPasswordLogin();
                if (passwordProvider == null) {
                    throw e;
                }
                try {
                    this.refreshWithPassword(passwordProvider);
                }
                catch (AuthenticationException e1) {
                    e1.addSuppressed((Throwable)e);
                    throw e1;
                }
            }
        }
    }

    public synchronized void refreshWithPassword(String username, String password) throws AuthenticationException {
        this.refreshWithPassword(username, password, null);
    }

    public synchronized void refreshWithPassword(String username, String password, CharacterSelector characterSelector) throws AuthenticationException {
        this.refreshWithPassword(YggdrasilAuthenticator.createPasswordProvider(username, password, characterSelector));
    }

    public synchronized void refreshWithPassword(PasswordProvider passwordProvider) throws AuthenticationException {
        this.refreshWithPassword(passwordProvider, UUIDUtils.randomUnsignedUUID());
    }

    public synchronized void refreshWithPassword(PasswordProvider passwordProvider, String clientToken) throws AuthenticationException {
        Objects.requireNonNull(passwordProvider);
        Objects.requireNonNull(clientToken);
        String username = passwordProvider.getUsername();
        String password = passwordProvider.getPassword();
        this.authResult = this.authenticationService.login(username, password, clientToken);
        if (this.authResult.getSelectedProfile() == null) {
            GameProfile selectedProfile;
            GameProfile[] profiles = this.authResult.getProfiles();
            if (profiles == null || profiles.length == 0) {
                return;
            }
            CharacterSelector selector = passwordProvider.getCharacterSelector();
            if (selector == null) {
                selector = new DefaultCharacterSelector();
            }
            if ((selectedProfile = selector.select(profiles)) != null) {
                this.authResult = this.authenticationService.selectProfile(this.authResult.getClientToken(), this.authResult.getAccessToken(), selectedProfile);
            }
        }
    }

    public synchronized void refreshWithToken(String clientToken, String accessToken) throws AuthenticationException {
        this.authResult = this.authenticationService.refresh(Objects.requireNonNull(clientToken), Objects.requireNonNull(accessToken));
    }

    public synchronized void clearToken() {
        this.authResult = null;
    }

    public synchronized Session getCurrentSession() {
        return this.authResult;
    }

    public synchronized void setCurrentSession(Session session) {
        this.authResult = session;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    protected PasswordProvider tryPasswordLogin() throws AuthenticationException {
        return null;
    }

    protected AuthenticationService createAuthenticationServiceForDeserialization() {
        return YggdrasilAuthenticationServiceBuilder.buildDefault();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        AuthenticationService newAuthenticationService = this.createAuthenticationServiceForDeserialization();
        if (newAuthenticationService == null) {
            throw new IllegalStateException("Cannot recreate AuthenticationService, createAuthenticationServiceForDeserialization() returns null.");
        }
        this.authenticationService = newAuthenticationService;
    }

    public static interface PasswordProvider {
        public String getUsername() throws AuthenticationException;

        public String getPassword() throws AuthenticationException;

        public CharacterSelector getCharacterSelector();
    }
}

