/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.DebugHttpRequester;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpRequester;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.MojangYggdrasilAPIProvider;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.PropertiesDeserializer;
import org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil.YggdrasilAPIProvider;
import org.to2mbn.jmccc.util.Builder;

public abstract class AbstractYggdrasilServiceBuilder<T>
implements Builder<T> {
    protected YggdrasilAPIProvider apiProvider;
    protected PublicKey sessionPublicKey;
    protected boolean useDefaultSessionPublicKey = true;
    protected Proxy proxy;
    protected boolean debug;

    protected AbstractYggdrasilServiceBuilder() {
    }

    private static PublicKey loadX509PublicKey(InputStream in) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        int read;
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            byteout.write(buffer, 0, read);
        }
        return AbstractYggdrasilServiceBuilder.loadX509PublicKey(byteout.toByteArray());
    }

    private static PublicKey loadX509PublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(spec);
    }

    private static PublicKey loadDefaultSessionPublicKey() {
        PublicKey publicKey;
        block8: {
            InputStream in = PropertiesDeserializer.class.getResourceAsStream("/yggdrasil_session_pubkey.der");
            try {
                publicKey = AbstractYggdrasilServiceBuilder.loadX509PublicKey(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IllegalStateException("Couldn't load default yggdrasil session public key.", e);
                }
            }
            in.close();
        }
        return publicKey;
    }

    public AbstractYggdrasilServiceBuilder<T> apiProvider(YggdrasilAPIProvider provider) {
        this.apiProvider = provider;
        return this;
    }

    public AbstractYggdrasilServiceBuilder<T> sessionPublicKey(PublicKey sessionPublicKey) {
        this.sessionPublicKey = sessionPublicKey;
        this.useDefaultSessionPublicKey = false;
        return this;
    }

    public AbstractYggdrasilServiceBuilder<T> loadSessionPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.sessionPublicKey(AbstractYggdrasilServiceBuilder.loadX509PublicKey(Objects.requireNonNull(encodedKey)));
    }

    public AbstractYggdrasilServiceBuilder<T> loadSessionPublicKey(InputStream in) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return this.sessionPublicKey(AbstractYggdrasilServiceBuilder.loadX509PublicKey(Objects.requireNonNull(in)));
    }

    public AbstractYggdrasilServiceBuilder<T> loadSessionPublicKey(File keyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try (FileInputStream in = new FileInputStream(Objects.requireNonNull(keyFile));){
            AbstractYggdrasilServiceBuilder<T> abstractYggdrasilServiceBuilder = this.sessionPublicKey(AbstractYggdrasilServiceBuilder.loadX509PublicKey(in));
            return abstractYggdrasilServiceBuilder;
        }
    }

    public AbstractYggdrasilServiceBuilder<T> loadSessionPublicKey(String keyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return this.loadSessionPublicKey(new File(Objects.requireNonNull(keyFile)));
    }

    public AbstractYggdrasilServiceBuilder<T> proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public AbstractYggdrasilServiceBuilder<T> debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    protected YggdrasilAPIProvider buildAPIProvider() {
        return this.apiProvider == null ? new MojangYggdrasilAPIProvider() : this.apiProvider;
    }

    protected HttpRequester buildHttpRequester() {
        HttpRequester requester = this.debug ? new DebugHttpRequester() : new HttpRequester();
        requester.setProxy(this.proxy);
        return requester;
    }

    protected PropertiesDeserializer buildPropertiesDeserializer() {
        return new PropertiesDeserializer(this.useDefaultSessionPublicKey ? AbstractYggdrasilServiceBuilder.loadDefaultSessionPublicKey() : this.sessionPublicKey);
    }
}

