/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.util;

public final class Base64 {
    private static final char[] ENCODE_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '='};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    private Base64() {
    }

    public static byte[] decode(char[] data) {
        data = Base64.deleteLineChars(data);
        int length = (data.length + 3) / 4 * 3;
        if (data.length > 0 && data[data.length - 1] == '=') {
            --length;
        }
        if (data.length > 1 && data[data.length - 2] == '=') {
            --length;
        }
        byte[] out = new byte[length];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            byte value = DECODE_TABLE[data[ix] & 0xFF];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        return out;
    }

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = ENCODE_TABLE[quad ? val & 0x3F : 63];
            out[index + 2] = ENCODE_TABLE[trip ? (val >>= 6) & 0x3F : 63];
            out[index + 1] = ENCODE_TABLE[(val >>= 6) & 0x3F];
            out[index + 0] = ENCODE_TABLE[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    private static char[] deleteLineChars(char[] in) {
        int length = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == '\n' || in[i] == '\r') continue;
            ++length;
        }
        if (length == in.length) {
            return in;
        }
        char[] out = new char[length];
        int l = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == '\n' || in[i] == '\r') continue;
            out[l++] = in[i];
        }
        return out;
    }
}

