/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.yggdrasil;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Map;
import java.util.TreeMap;
import org.to2mbn.jmccc.auth.yggdrasil.core.util.Base64;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;

class PropertiesDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PublicKey signaturePublicKey;

    public PropertiesDeserializer(PublicKey signaturePublicKey) {
        this.signaturePublicKey = signaturePublicKey;
    }

    public Map<String, String> toProperties(JSONArray props, boolean forceSignature) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, JSONException {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        for (int i = 0; i < props.length(); ++i) {
            JSONObject prop = props.getJSONObject(i);
            String key = prop.getString("name");
            String value = prop.getString("value");
            if (prop.has("signature")) {
                if (this.signaturePublicKey == null) {
                    if (!forceSignature) continue;
                    throw new InvalidKeyException("No available key");
                }
                String signature = prop.getString("signature");
                this.checkSignature(value, signature);
            } else if (forceSignature) {
                throw new SignatureException("No available signature");
            }
            properties.put(key, value);
        }
        return properties;
    }

    private void checkSignature(String value, String signature) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        Signature verifier = Signature.getInstance("SHA1withRSA");
        verifier.initVerify(this.signaturePublicKey);
        verifier.update(value.getBytes());
        if (!verifier.verify(Base64.decode(signature.toCharArray()))) {
            throw new SignatureException("Invalid signature. data=[" + value + "], expectedSignature=[" + signature + "]");
        }
    }
}

