/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.texture;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.Texture;

public enum SkinModel {
    STEVE(""),
    ALEX("slim");

    public static final String METADATA_KEY_MODEL = "model";
    private String modelName;
    private Map<String, String> metadata;

    private SkinModel(String modelName) {
        this.modelName = modelName;
        HashMap<String, String> modifiableMetadata = new HashMap<String, String>();
        modifiableMetadata.put(METADATA_KEY_MODEL, modelName);
        this.metadata = Collections.unmodifiableMap(modifiableMetadata);
    }

    public static SkinModel inferModel(Texture texture) {
        if (texture == null) {
            return STEVE;
        }
        return SkinModel.inferModel(texture.getMetadata());
    }

    public static SkinModel inferModel(Map<String, String> metadata) {
        if (metadata != null && SkinModel.ALEX.modelName.equals(metadata.get(METADATA_KEY_MODEL))) {
            return ALEX;
        }
        return STEVE;
    }

    public String modelName() {
        return this.modelName;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }
}

