/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth.yggdrasil.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.to2mbn.jmccc.util.IOUtils;

public class HttpRequester {
    private static final int TIMEOUT = 15000;
    private Proxy proxy;

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String request(String method, String url) throws IOException {
        return this.request(method, url, null);
    }

    public String request(String method, String url, Map<String, String> headers) throws IOException {
        HttpURLConnection connection = this.createHttpConnection(url, headers);
        connection.setRequestMethod(method);
        try {
            String string;
            block18: {
                connection.connect();
                InputStream in = connection.getInputStream();
                try {
                    string = IOUtils.toString((InputStream)in);
                    if (in == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        try (InputStream in2 = connection.getErrorStream();){
                            String string2 = this.readErrorStream(in2, e);
                            return string2;
                        }
                    }
                }
                in.close();
            }
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    public String requestWithPayload(String method, String url, Object payload, String contentType) throws IOException {
        return this.requestWithPayload(method, url, payload, contentType, null);
    }

    public String requestWithPayload(String method, String url, Object payload, String contentType, Map<String, String> headers) throws IOException {
        byte[] bytePayload = payload instanceof byte[] ? (byte[])payload : (payload == null ? new byte[]{} : String.valueOf(payload).getBytes("UTF-8"));
        HttpURLConnection connection = this.createHttpConnection(url, headers);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("Content-Length", String.valueOf(bytePayload.length));
        connection.setDoOutput(true);
        try {
            String string;
            block25: {
                connection.connect();
                try (OutputStream out = connection.getOutputStream();){
                    out.write(bytePayload);
                }
                InputStream in = connection.getInputStream();
                try {
                    string = IOUtils.toString((InputStream)in);
                    if (in == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        try (InputStream in2 = connection.getErrorStream();){
                            String string2 = this.readErrorStream(in2, e);
                            return string2;
                        }
                    }
                }
                in.close();
            }
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    private String readErrorStream(InputStream in, IOException e) throws IOException {
        if (in == null) {
            throw e;
        }
        try {
            return IOUtils.toString((InputStream)in);
        }
        catch (IOException e1) {
            if (e != e1) {
                e1.addSuppressed(e);
            }
            throw e1;
        }
    }

    private HttpURLConnection createHttpConnection(String url, Map<String, String> headers) throws UnsupportedEncodingException, MalformedURLException, IOException {
        HttpURLConnection connection = this.createHttpConnection(new URL(url));
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        return connection;
    }

    private HttpURLConnection createHttpConnection(URL url) throws IOException {
        Proxy usingProxy = this.proxy;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(usingProxy == null ? Proxy.NO_PROXY : usingProxy);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        return connection;
    }
}

