/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mojangapi.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import org.to2mbn.jmccc.util.HexUtils;

public class MultipartBuilder {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int READY = 0;
    private static final int DISPOSITION = 1;
    private static final int HEADERS = 2;
    private static final int FINISHED = 3;
    private String boundary = MultipartBuilder.randomBoundary();
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private Writer writer = new OutputStreamWriter((OutputStream)this.out, Charset.forName("UTF-8"));
    private int status = 0;

    private static String randomBoundary() {
        byte[] rnd = new byte[8];
        RANDOM.nextBytes(rnd);
        return "---------------------------" + HexUtils.bytesToHex((byte[])rnd);
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getContentType() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    public MultipartBuilder disposition(String key, String value) throws IOException {
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException("The current status is " + this.status + ", expected: " + 0 + " or " + 1);
        }
        if (this.status == 0) {
            this.status = 1;
            this.writer.write("--");
            this.writer.write(this.boundary);
            this.writer.write("\r\nContent-Disposition: form-data");
        }
        this.writer.write("; ");
        this.writer.write(key);
        this.writer.write("=\"");
        this.writer.write(value);
        this.writer.write("\"");
        return this;
    }

    public MultipartBuilder header(String key, String value) throws IOException {
        if (this.status != 1 && this.status != 2) {
            throw new IllegalStateException("The current status is " + this.status + ", expected: " + 1 + " or " + 2);
        }
        if (this.status == 1) {
            this.status = 2;
            this.writer.write("\r\n");
        }
        this.writer.write(key);
        this.writer.write(": ");
        this.writer.write(value);
        this.writer.write("\r\n");
        return this;
    }

    public MultipartBuilder content(byte[] payload) throws IOException {
        if (this.status != 1 && this.status != 2) {
            throw new IllegalStateException("The current status is " + this.status + ", expected: " + 1 + " or " + 2);
        }
        if (this.status == 1) {
            this.writer.write("\r\n");
        }
        this.status = 0;
        this.writer.write("\r\n");
        this.writer.flush();
        this.out.write(payload);
        this.writer.write("\r\n");
        return this;
    }

    public byte[] finish() throws IOException {
        if (this.status != 0) {
            throw new IllegalStateException("The current status is " + this.status + ", expected: " + 0);
        }
        this.status = 3;
        this.writer.write("--");
        this.writer.write(this.boundary);
        this.writer.write("--\r\n");
        this.writer.flush();
        return this.out.toByteArray();
    }
}

