/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mojangapi;

import java.net.Proxy;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.DebugHttpRequester;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpRequester;
import org.to2mbn.jmccc.mojangapi.DefaultMojangAPIProvider;
import org.to2mbn.jmccc.mojangapi.MojangAPI;
import org.to2mbn.jmccc.mojangapi.MojangAPIImpl;
import org.to2mbn.jmccc.mojangapi.MojangAPIProvider;
import org.to2mbn.jmccc.util.Builder;

public class MojangAPIBuilder
implements Builder<MojangAPI> {
    private MojangAPIProvider apiProvider;
    private Proxy proxy;
    private boolean debug;

    public static MojangAPIBuilder create() {
        return new MojangAPIBuilder();
    }

    public static MojangAPI buildDefault() {
        return MojangAPIBuilder.create().build();
    }

    public MojangAPIBuilder apiProvider(MojangAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
        return this;
    }

    public MojangAPIBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public MojangAPIBuilder debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    protected MojangAPIProvider buildAPIProvider() {
        return this.apiProvider == null ? new DefaultMojangAPIProvider() : this.apiProvider;
    }

    protected HttpRequester buildHttpRequester() {
        DebugHttpRequester requester = this.debug ? new DebugHttpRequester() : new HttpRequester();
        requester.setProxy(this.proxy);
        return requester;
    }

    public MojangAPI build() {
        return new MojangAPIImpl(this.buildHttpRequester(), this.buildAPIProvider());
    }
}

