/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mojangapi;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.to2mbn.jmccc.mojangapi.BlockedServerList;
import org.to2mbn.jmccc.util.HexUtils;

class SHA1BlockedServerList
implements BlockedServerList {
    private static final long serialVersionUID = 1L;
    private static final Pattern IP_REGEX = Pattern.compile("^(2[0-4]\\d|25[0-5]|1\\d\\d|[1-9]?\\d)(\\.(2[0-4]\\d|25[0-5]|1\\d\\d|[1-9]?\\d)){3}$");
    private Set<String> entries;

    public SHA1BlockedServerList(Set<String> entries) throws NoSuchAlgorithmException {
        this.entries = Objects.requireNonNull(entries);
    }

    @Override
    public boolean isBlocked(String host) {
        InetAddress address;
        if (this.isBlockedServer(host)) {
            return true;
        }
        try {
            address = InetAddress.getByName(null);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return this.isBlockedServer(address.getHostAddress()) || this.isBlockedServer(address.getHostName());
    }

    @Override
    public String[] getEntries() {
        return this.entries.toArray(new String[this.entries.size()]);
    }

    private boolean isInBlockedList(String str) {
        try {
            return this.entries.contains(HexUtils.bytesToHex((byte[])MessageDigest.getInstance("SHA-1").digest(str.toLowerCase().getBytes("ISO-8859-1"))));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isBlockedServer(String server) {
        int lastNonDotIdx;
        if (server == null || server.isEmpty()) {
            return false;
        }
        for (lastNonDotIdx = server.length() - 1; lastNonDotIdx >= 0 && server.charAt(lastNonDotIdx) == '.'; --lastNonDotIdx) {
        }
        if (lastNonDotIdx < 0) {
            return false;
        }
        if (this.isInBlockedList(server = server.substring(0, lastNonDotIdx + 1))) {
            return true;
        }
        boolean isIp = IP_REGEX.matcher(server).matches();
        if (isIp) {
            int currentIdx = server.length();
            for (int i = 0; i < 3; ++i) {
                if (!this.isInBlockedList(server.substring(0, (currentIdx = server.lastIndexOf(46, currentIdx - 1)) + 1) + "*")) continue;
                return true;
            }
        } else {
            int currentIdx = -1;
            while ((currentIdx = server.indexOf(46, currentIdx + 1)) != -1) {
                if (!this.isInBlockedList("*" + server.substring(currentIdx))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SHA1BlockedServerList) {
            SHA1BlockedServerList another = (SHA1BlockedServerList)obj;
            return Objects.equals(this.entries, another.entries);
        }
        return false;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return String.format("SHA1BlockedServerList [entries=%s]", this.entries);
    }
}

