/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mojangapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.to2mbn.jmccc.auth.AuthenticationException;
import org.to2mbn.jmccc.auth.yggdrasil.SessionCredential;
import org.to2mbn.jmccc.auth.yggdrasil.core.RemoteAuthenticationException;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.AbstractClientService;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpRequester;
import org.to2mbn.jmccc.auth.yggdrasil.core.io.HttpUtils;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.Texture;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.TextureType;
import org.to2mbn.jmccc.auth.yggdrasil.core.texture.URLTexture;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mojangapi.AccountInfo;
import org.to2mbn.jmccc.mojangapi.BlockedServerList;
import org.to2mbn.jmccc.mojangapi.FormerName;
import org.to2mbn.jmccc.mojangapi.MojangAPI;
import org.to2mbn.jmccc.mojangapi.MojangAPIProvider;
import org.to2mbn.jmccc.mojangapi.SHA1BlockedServerList;
import org.to2mbn.jmccc.mojangapi.SalesStatistics;
import org.to2mbn.jmccc.mojangapi.ServiceStatus;
import org.to2mbn.jmccc.mojangapi.io.MultipartBuilder;
import org.to2mbn.jmccc.util.IOUtils;

class MojangAPIImpl
extends AbstractClientService
implements MojangAPI {
    private MojangAPIProvider api;

    public MojangAPIImpl(HttpRequester requester, MojangAPIProvider api) {
        super(requester);
        this.api = api;
    }

    @Override
    public Map<String, ServiceStatus> getServiceStatus() throws AuthenticationException {
        return (Map)this.invokeOperation(new Callable<Map<String, ServiceStatus>>(){

            @Override
            public Map<String, ServiceStatus> call() throws Exception {
                JSONArray response = MojangAPIImpl.this.requireJsonArray(MojangAPIImpl.this.requester.request("GET", MojangAPIImpl.this.api.apiStatus()));
                TreeMap<String, ServiceStatus> result = new TreeMap<String, ServiceStatus>();
                for (Object rawEntry : response) {
                    JSONObject serviceEntry = (JSONObject)rawEntry;
                    for (String service : serviceEntry.keySet()) {
                        ServiceStatus status = ServiceStatus.valueOf(serviceEntry.getString(service).toUpperCase());
                        result.put(service, status);
                    }
                }
                return Collections.unmodifiableMap(result);
            }
        });
    }

    @Override
    public FormerName[] getNameHistory(final UUID uuid) throws AuthenticationException {
        Objects.requireNonNull(uuid);
        return (FormerName[])this.invokeOperation(new Callable<FormerName[]>(){

            @Override
            public FormerName[] call() throws Exception {
                JSONArray response = MojangAPIImpl.this.requireJsonArray(MojangAPIImpl.this.requester.request("GET", MojangAPIImpl.this.api.nameHistory(uuid)));
                FormerName[] names = new FormerName[response.length()];
                for (int i = 0; i < names.length; ++i) {
                    JSONObject entry = response.getJSONObject(i);
                    String name = entry.getString("name");
                    Long changedToAt = entry.has("changedToAt") ? Long.valueOf(entry.getLong("changedToAt")) : null;
                    names[i] = new FormerName(name, changedToAt);
                }
                return names;
            }
        });
    }

    @Override
    public void setTexture(final SessionCredential credential, final UUID uuid, final TextureType type, final Texture texture) throws AuthenticationException {
        Objects.requireNonNull(credential);
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(type);
        this.invokeOperation(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String url = MojangAPIImpl.this.api.texture(uuid, type);
                Map headers = MojangAPIImpl.this.getAuthorizationHeaders(credential);
                if (texture == null) {
                    MojangAPIImpl.this.requireEmpty(MojangAPIImpl.this.requester.request("DELETE", url, headers));
                } else if (texture instanceof URLTexture) {
                    try {
                        MojangAPIImpl.this.updateTexture((URLTexture)texture, url, headers);
                    }
                    catch (RemoteAuthenticationException exUpdate) {
                        if ("IllegalArgumentException".equals(exUpdate.getRemoteExceptionName())) {
                            try {
                                MojangAPIImpl.this.uploadTexture(texture, url, headers);
                            }
                            catch (Exception exUpload) {
                                exUpload.addSuppressed(exUpdate);
                                throw exUpload;
                            }
                        }
                        throw exUpdate;
                    }
                } else {
                    MojangAPIImpl.this.uploadTexture(texture, url, headers);
                }
                return null;
            }
        });
    }

    private void updateTexture(URLTexture texture, String url, Map<String, String> headers) throws AuthenticationException, JSONException, IOException {
        HashMap<String, URL> form = new HashMap<String, URL>();
        Map metadata = texture.getMetadata();
        if (metadata != null) {
            form.putAll(metadata);
        }
        form.put("url", texture.getURL());
        this.requireEmpty(this.requester.requestWithPayload("POST", url, (Object)HttpUtils.encodeForm(form), "application/x-www-form-urlencoded", headers));
    }

    private void uploadTexture(Texture texture, String url, Map<String, String> headers) throws AuthenticationException, JSONException, IOException {
        byte[] image;
        try (InputStream in = texture.openStream();){
            image = IOUtils.toByteArray((InputStream)in);
        }
        MultipartBuilder multipart = new MultipartBuilder();
        Map metadata = texture.getMetadata();
        if (metadata != null) {
            for (Map.Entry property : metadata.entrySet()) {
                multipart.disposition("name", (String)property.getKey()).content(((String)property.getValue()).getBytes("UTF-8"));
            }
        }
        multipart.disposition("name", "file").header("Content-Type", "image/png").content(image);
        this.requireEmpty(this.requester.requestWithPayload("PUT", url, (Object)multipart.finish(), multipart.getContentType(), headers));
    }

    @Override
    public AccountInfo getAccountInfo(final SessionCredential credential) throws AuthenticationException {
        return (AccountInfo)this.invokeOperation(new Callable<AccountInfo>(){

            @Override
            public AccountInfo call() throws Exception {
                JSONObject response = MojangAPIImpl.this.requireJsonObject(MojangAPIImpl.this.requester.request("GET", MojangAPIImpl.this.api.userInfo(), MojangAPIImpl.this.getAuthorizationHeaders(credential)));
                String id = response.has("id") ? response.getString("id") : null;
                String email = response.has("email") ? response.getString("email") : null;
                String username = response.has("username") ? response.getString("username") : null;
                String registerIp = response.has("registerIp") ? response.getString("registerIp") : null;
                Long registeredAt = response.has("registeredAt") ? Long.valueOf(response.getLong("registeredAt")) : null;
                Long passwordChangedAt = response.has("passwordChangedAt") ? Long.valueOf(response.getLong("passwordChangedAt")) : null;
                Long dateOfBirth = response.has("dateOfBirth") ? Long.valueOf(response.getLong("dateOfBirth")) : null;
                Boolean deleted = response.has("deleted") ? Boolean.valueOf(response.getBoolean("deleted")) : null;
                Boolean blocked = response.has("blocked") ? Boolean.valueOf(response.getBoolean("blocked")) : null;
                Boolean secured = response.has("secured") ? Boolean.valueOf(response.getBoolean("secured")) : null;
                Boolean migrated = response.has("migrated") ? Boolean.valueOf(response.getBoolean("migrated")) : null;
                Boolean emailVerified = response.has("emailVerified") ? Boolean.valueOf(response.getBoolean("emailVerified")) : null;
                Boolean legacyUser = response.has("legacyUser") ? Boolean.valueOf(response.getBoolean("legacyUser")) : null;
                Boolean verifiedByParent = response.has("verifiedByParent") ? Boolean.valueOf(response.getBoolean("verifiedByParent")) : null;
                String fullName = response.has("fullName") ? response.getString("fullName") : null;
                Boolean fromMigratedUser = response.has("fromMigratedUser") ? Boolean.valueOf(response.getBoolean("fromMigratedUser")) : null;
                Boolean hashed = response.has("hashed") ? Boolean.valueOf(response.getBoolean("hashed")) : null;
                return new AccountInfo(id, email, username, registerIp, registeredAt, passwordChangedAt, dateOfBirth, deleted, blocked, secured, migrated, emailVerified, legacyUser, verifiedByParent, fullName, fromMigratedUser, hashed);
            }
        });
    }

    @Override
    public BlockedServerList getBlockedServerList() throws AuthenticationException {
        return (BlockedServerList)this.invokeOperation(new Callable<BlockedServerList>(){

            @Override
            public BlockedServerList call() throws Exception {
                String response = MojangAPIImpl.this.requester.request("GET", MojangAPIImpl.this.api.blockedServers());
                if (response.trim().startsWith("{")) {
                    MojangAPIImpl.this.requireJsonObject(response);
                    throw new AuthenticationException("Illegal response: " + response);
                }
                String[] entries = response.split("\n");
                LinkedHashSet<String> entriesSet = new LinkedHashSet<String>();
                for (String entry : entries) {
                    if ((entry = entry.trim()).isEmpty()) continue;
                    entriesSet.add(entry);
                }
                return new SHA1BlockedServerList(entriesSet);
            }
        });
    }

    @Override
    public SalesStatistics querySales(final String ... metricKeys) throws AuthenticationException {
        return (SalesStatistics)this.invokeOperation(new Callable<SalesStatistics>(){

            @Override
            public SalesStatistics call() throws Exception {
                JSONObject request = new JSONObject();
                request.put("metricKeys", (Object)metricKeys);
                JSONObject response = MojangAPIImpl.this.requireJsonObject(MojangAPIImpl.this.requester.requestWithPayload("POST", MojangAPIImpl.this.api.salesStatistics(), (Object)request, "application/json; charset=utf-8"));
                long total = response.optLong("total", -1L);
                long last24h = response.optLong("last24h", -1L);
                long saleVelocityPerSeconds = response.optLong("saleVelocityPerSeconds", -1L);
                return new SalesStatistics(total, last24h, saleVelocityPerSeconds);
            }
        });
    }

    private Map<String, String> getAuthorizationHeaders(SessionCredential credential) throws AuthenticationException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer: " + credential.session().getAccessToken());
        return headers;
    }
}

