/*
 * Decompiled with CFR 0.152.
 */
package jmccc.microsoft;

import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import jmccc.microsoft.core.MicrosoftAuthenticationController;
import jmccc.microsoft.entity.MicrosoftSession;
import jmccc.microsoft.entity.MicrosoftVerification;
import jmccc.microsoft.entity.MinecraftProfile;
import org.to2mbn.jmccc.auth.AuthInfo;
import org.to2mbn.jmccc.auth.AuthenticationException;
import org.to2mbn.jmccc.auth.Authenticator;
import org.to2mbn.jmccc.util.UUIDUtils;

public class MicrosoftAuthenticator
implements Authenticator {
    private static String clientId;
    private MinecraftProfile profile;
    private MicrosoftSession session;
    private final MicrosoftAuthenticationController controller = new MicrosoftAuthenticationController(clientId);

    private MicrosoftAuthenticator() {
    }

    public static MicrosoftAuthenticator session(MicrosoftSession session, Consumer<MicrosoftVerification> callback) throws AuthenticationException {
        MicrosoftAuthenticator authenticator = new MicrosoftAuthenticator();
        MicrosoftAuthenticationController controller = authenticator.controller;
        authenticator.session = session;
        try {
            authenticator.profile = controller.getMinecraftProfile(session);
            return authenticator;
        }
        catch (AuthenticationException authenticationException) {
            try {
                session = controller.refreshMicrosoftToken(session);
                authenticator.session = session = controller.getMinecraftToken(session);
                authenticator.profile = controller.getMinecraftProfile(session);
                return authenticator;
            }
            catch (AuthenticationException authenticationException2) {
                return MicrosoftAuthenticator.login(callback);
            }
        }
    }

    public static MicrosoftAuthenticator login(Consumer<MicrosoftVerification> callback) throws AuthenticationException {
        Objects.requireNonNull(callback);
        MicrosoftAuthenticator authenticator = new MicrosoftAuthenticator();
        MicrosoftAuthenticationController controller = authenticator.controller;
        authenticator.session = controller.getMinecraftToken(controller.getMicrosoftToken(callback));
        authenticator.profile = controller.getMinecraftProfile(authenticator.session);
        return authenticator;
    }

    public AuthInfo auth() {
        Objects.requireNonNull(this.profile);
        return new AuthInfo(this.profile.name, this.session.minecraftAccessToken, UUIDUtils.toUUID((String)this.profile.id), Collections.emptyMap(), "msa", this.session.xboxUserId);
    }

    public MicrosoftSession getSession() {
        return this.session;
    }

    public static void setClientId(String clientId) {
        MicrosoftAuthenticator.clientId = clientId;
    }
}

