/*
 * Decompiled with CFR 0.152.
 */
package jmccc.cli.download;

import java.util.concurrent.ExecutionException;
import jmccc.cli.download.BmclApiProvider;
import jmccc.cli.download.CliCallback;
import org.to2mbn.jmccc.mcdownloader.CacheOption;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloadOption;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloader;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloaderBuilder;
import org.to2mbn.jmccc.mcdownloader.RemoteVersionList;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.provider.DownloadProviderChain;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.MojangDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.fabric.FabricDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeDownloadSource;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderDownloadSource;
import org.to2mbn.jmccc.mcdownloader.provider.quilt.QuiltDownloadProvider;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.Builder;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Version;

public class CliDownloader {
    public static ForgeDownloadProvider forgeProvider;
    public static LiteloaderDownloadProvider liteloaderProvider;
    public static FabricDownloadProvider fabricProvider;
    public static FabricDownloadProvider quiltProvider;
    public static MinecraftDownloader downloader;

    public static void init(boolean isBmclApi) {
        BmclApiProvider bmclApiProvider = isBmclApi ? new BmclApiProvider() : null;
        forgeProvider = new ForgeDownloadProvider((ForgeDownloadSource)bmclApiProvider);
        liteloaderProvider = new LiteloaderDownloadProvider((LiteloaderDownloadSource)bmclApiProvider);
        fabricProvider = new FabricDownloadProvider();
        quiltProvider = new QuiltDownloadProvider();
        downloader = MinecraftDownloaderBuilder.create().providerChain((Builder)DownloadProviderChain.create().baseProvider((MinecraftDownloadProvider)(bmclApiProvider == null ? new MojangDownloadProvider() : bmclApiProvider)).addProvider((MinecraftDownloadProvider)forgeProvider).addProvider((MinecraftDownloadProvider)liteloaderProvider).addProvider((MinecraftDownloadProvider)fabricProvider).addProvider((MinecraftDownloadProvider)quiltProvider)).build();
    }

    public static String getLatestRelease() throws ExecutionException, InterruptedException {
        return ((RemoteVersionList)downloader.fetchRemoteVersionList(null, new CacheOption[0]).get()).getLatestRelease();
    }

    public static String getLatestSnapshot() throws ExecutionException, InterruptedException {
        return ((RemoteVersionList)downloader.fetchRemoteVersionList(null, new CacheOption[0]).get()).getLatestSnapshot();
    }

    public static Version download(MinecraftDirectory dir, String version) throws ExecutionException, InterruptedException {
        return (Version)downloader.downloadIncrementally(dir, version, new CliCallback(), new MinecraftDownloadOption[0]).get();
    }

    public static void downloadLibrary(MinecraftDirectory dir, Library lib) throws ExecutionException, InterruptedException {
        downloader.download(downloader.getProvider().library(dir, lib), new CliCallback()).get();
    }

    public static <T> T get(CombinedDownloadTask<T> task) throws ExecutionException, InterruptedException {
        return (T)downloader.download(task, new CliCallback()).get();
    }
}

